/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.video.service.VideoConversion;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class VideoConversionContributionHandler
extends ContributionFragmentRegistry<VideoConversion> {
    public final Map<String, VideoConversion> registry = new HashMap<String, VideoConversion>();

    public String getContributionId(VideoConversion contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, VideoConversion contrib, VideoConversion newOrigContrib) {
        if (contrib.isEnabled()) {
            this.registry.put(id, contrib);
        } else {
            this.registry.remove(id);
        }
    }

    public void contributionRemoved(String id, VideoConversion origContrib) {
        this.registry.remove(id);
    }

    public VideoConversion clone(VideoConversion object) {
        try {
            return object.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void merge(VideoConversion src, VideoConversion dst) {
        dst.setConverter(src.getConverter());
        dst.setHeight(src.getHeight());
        dst.setEnabled(src.isEnabled());
        if (src.isRenditionSet()) {
            dst.setRendition(src.isRendition());
        }
        if (src.isRenditionVisibleSet()) {
            dst.setRenditionVisible(src.isRenditionVisible());
        }
    }
}

