/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.tools.VideoTool;
import org.nuxeo.runtime.api.Framework;

public class VideoClosedCaptionsExtractor
extends VideoTool {
    public static final String NAME = "ccExtractorTool";
    public static final String START_AT_PARAM = "startAt";
    public static final String END_AT_PARAM = "endAt";
    public static final String OUTPUT_FORMAT_PARAM = "outFormat";
    protected static final String COMMANDLINE_FULL_VIDEO = "videoClosedCaptionsExtractor";
    protected static final String COMMANDLINE_SLICED_VIDEO = "videoPartClosedCaptionsExtractor";
    protected static final String DEFAULT_OUTFORMAT = "ttxt";
    protected static final List<String> TEXT_OUTFORMATS = Arrays.asList("srt", "txt", "ttxt");

    public VideoClosedCaptionsExtractor() {
        super(NAME, COMMANDLINE_FULL_VIDEO);
    }

    public List<String> getSupportedFormats() {
        return TEXT_OUTFORMATS;
    }

    public boolean isFormatSupported(String format) {
        return TEXT_OUTFORMATS.contains(format);
    }

    @Override
    public Map<String, String> setupParameters(BlobHolder blobHolder, Map<String, Object> parameters) {
        Map<String, String> cmdParameters = super.setupParameters(blobHolder, parameters);
        Blob video = blobHolder.getBlob();
        String outputFormat = (String)parameters.get(OUTPUT_FORMAT_PARAM);
        String startAt = (String)parameters.get(START_AT_PARAM);
        String endAt = (String)parameters.get(END_AT_PARAM);
        if (StringUtils.isEmpty((CharSequence)outputFormat)) {
            outputFormat = DEFAULT_OUTFORMAT;
        }
        cmdParameters.put(OUTPUT_FORMAT_PARAM, outputFormat);
        cmdParameters.put("outputMimetype", outputFormat.equals(DEFAULT_OUTFORMAT) ? "text/xml" : "text/plain");
        if (!StringUtils.isBlank((CharSequence)startAt) && !StringUtils.isBlank((CharSequence)endAt)) {
            cmdParameters.put(START_AT_PARAM, startAt);
            cmdParameters.put(END_AT_PARAM, endAt);
            this.commandLineName = COMMANDLINE_SLICED_VIDEO;
        }
        try {
            File outputFile = Framework.createTempFile((String)FilenameUtils.removeExtension((String)video.getFilename()), (String)("-CC." + outputFormat));
            cmdParameters.put("outFilePath", outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot setup parameters for VideoClosedCaptionsExtractor", (Throwable)e);
        }
        return cmdParameters;
    }
}

