/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.elements;

import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.java.dev.webdav.jaxrs.xml.elements.Depth;
import net.java.dev.webdav.jaxrs.xml.elements.LockRoot;
import net.java.dev.webdav.jaxrs.xml.elements.LockScope;
import net.java.dev.webdav.jaxrs.xml.elements.LockToken;
import net.java.dev.webdav.jaxrs.xml.elements.LockType;
import net.java.dev.webdav.jaxrs.xml.elements.Owner;
import net.java.dev.webdav.jaxrs.xml.elements.TimeOut;
import net.java.dev.webdav.util.Utilities;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"lockScope", "lockType", "depth", "owner", "timeOut", "lockToken", "lockRoot"})
@XmlRootElement(name="activelock")
public final class ActiveLock {
    @XmlElement(name="lockscope")
    private final LockScope lockScope;
    @XmlElement(name="locktype")
    private final LockType lockType;
    private final Depth depth;
    private final Owner owner;
    @XmlElement(name="timeout")
    private final TimeOut timeOut;
    @XmlElement(name="locktoken")
    private final LockToken lockToken;
    @XmlElement(name="lockroot")
    private final LockRoot lockRoot;

    private ActiveLock() {
        this.lockScope = null;
        this.lockType = null;
        this.depth = null;
        this.owner = null;
        this.timeOut = null;
        this.lockToken = null;
        this.lockRoot = null;
    }

    public ActiveLock(LockScope lockScope, LockType lockType, Depth depth, Owner owner, TimeOut timeOut, LockToken lockToken, LockRoot lockRoot) {
        this.lockScope = Utilities.notNull(lockScope, "lockScope");
        this.lockType = Utilities.notNull(lockType, "lockType");
        this.depth = Utilities.notNull(depth, "depth");
        this.owner = owner;
        this.timeOut = timeOut;
        this.lockToken = lockToken;
        this.lockRoot = Utilities.notNull(lockRoot, "lockRoot");
    }

    public final LockScope getLockScope() {
        return this.lockScope;
    }

    public final LockType getLockType() {
        return this.lockType;
    }

    @Deprecated
    public final Depth depth() {
        return this.depth;
    }

    public final Depth getDepth() {
        return this.depth;
    }

    public final Owner getOwner() {
        return this.owner;
    }

    public final TimeOut getTimeOut() {
        return this.timeOut;
    }

    public final LockToken getLockToken() {
        return this.lockToken;
    }

    public final LockRoot getLockRoot() {
        return this.lockRoot;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.lockScope, this.lockType, this.depth, this.owner, this.timeOut, this.lockToken, this.lockRoot});
    }

    public final boolean equals(Object other) {
        if (!(other instanceof ActiveLock)) {
            return false;
        }
        ActiveLock that = (ActiveLock)other;
        return Arrays.equals(Utilities.array(new Object[]{this.lockScope, this.lockType, this.depth, this.owner, this.timeOut, this.lockToken, this.lockRoot}), Utilities.array(new Object[]{that.lockScope, that.lockType, that.depth, that.owner, that.timeOut, that.lockToken, that.lockRoot}));
    }

    public final String toString() {
        return Utilities.toString(this, new Object[]{this.lockScope, this.lockToken, this.depth, this.owner, this.timeOut, this.lockToken, this.lockRoot});
    }
}

