/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class IWork2PDFConverter
implements Converter {
    public static final List<String> IWORK_MIME_TYPES = Arrays.asList("application/vnd.apple.pages", "application/vnd.apple.keynote", "application/vnd.apple.numbers", "application/vnd.apple.iwork");
    private static final String IWORK_PREVIEW_FILE = "QuickLook/Preview.pdf";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            Blob blob = blobHolder.getBlob();
            String mimeType = blob.getMimeType();
            if (mimeType == null) throw new ConversionException("not an iWork file", blobHolder);
            if (!IWORK_MIME_TYPES.contains(mimeType)) {
                throw new ConversionException("not an iWork file", blobHolder);
            }
            try (InputStream blobStream = blob.getStream();){
                if (!ZipUtils.isValid((InputStream)blobStream)) {
                    throw new ConversionException("not a valid iWork file", blobHolder);
                }
            }
            blobStream = blob.getStream();
            try {
                Blob previewBlob;
                if (!ZipUtils.hasEntry((InputStream)blobStream, (String)IWORK_PREVIEW_FILE)) throw new ConversionException("iWork file does not contain a pdf preview.", blobHolder);
                try (InputStream previewPDFFile = ZipUtils.getEntryContentAsStream((InputStream)blob.getStream(), (String)IWORK_PREVIEW_FILE);){
                    previewBlob = Blobs.createBlob((InputStream)previewPDFFile);
                }
                SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder(previewBlob);
                return simpleCachableBlobHolder;
            }
            finally {
                if (blobStream != null) {
                    blobStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new ConversionException("Could not find the pdf preview in the iWork file", blobHolder, (Throwable)e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

