/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import org.nuxeo.ecm.core.storage.sql.BaseProperty;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

public class CollectionProperty
extends BaseProperty {
    private final Fragment fragment;
    private final String key;

    public CollectionProperty(String name, PropertyType type, boolean readonly, CollectionFragment fragment) {
        super(name, type, readonly);
        this.fragment = fragment;
        this.key = null;
    }

    public CollectionProperty(String name, PropertyType type, boolean readonly, SimpleFragment fragment, String key) {
        super(name, type, readonly);
        this.fragment = fragment;
        this.key = key;
    }

    public Serializable[] getValue() {
        Serializable[] value = null;
        if (this.hasCollectionFragment()) {
            value = ((CollectionFragment)this.fragment).get();
        } else {
            value = (Serializable[])((SimpleFragment)this.fragment).get(this.key);
            if (value == null) {
                value = this.type.getEmptyArray();
            }
        }
        return value;
    }

    public String[] getStrings() {
        switch (this.type) {
            case ARRAY_STRING: {
                Object[] res = this.getValue();
                if (res.length == 0) {
                    res = new String[]{};
                }
                return (String[])res;
            }
        }
        throw new UnsupportedOperationException("Not implemented: " + this.type);
    }

    public void setValue(Object[] value) {
        this.checkWritable();
        try {
            if (this.hasCollectionFragment()) {
                ((CollectionFragment)this.fragment).set(this.type.normalize(value));
            } else {
                ((SimpleFragment)this.fragment).put(this.key, (Serializable)this.type.normalize(value));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("item of list property '" + this.name + "': " + e.getMessage());
        }
    }

    private boolean hasCollectionFragment() {
        return this.key == null;
    }
}

