/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentExistsException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.FulltextExtractorWork;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.FragmentGroup;
import org.nuxeo.ecm.core.storage.sql.FragmentsMap;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SessionImpl
implements Session {
    private static final Log log = LogFactory.getLog(SessionImpl.class);
    public static final String COMPAT_REPOSITORY_NAME_KEY = "org.nuxeo.vcs.repository.name.default.compat";
    private static final boolean COMPAT_REPOSITORY_NAME = Boolean.parseBoolean(Framework.getProperty((String)"org.nuxeo.vcs.repository.name.default.compat", (String)"true"));
    protected final RepositoryImpl repository;
    private final Mapper mapper;
    private final Model model;
    public final PersistenceContext context;
    protected final boolean changeTokenEnabled;
    protected final FulltextDescriptor fulltextDescriptor;
    private boolean inTransaction;
    private Serializable rootNodeId;
    private boolean readAclsChanged;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    private final Timer saveTimer;
    private final Timer queryTimer;
    private final Timer aclrUpdateTimer;
    private static final String LOG_MIN_DURATION_KEY = "org.nuxeo.vcs.query.log_min_duration_ms";
    private static final long LOG_MIN_DURATION_NS = Long.parseLong(Framework.getProperty((String)"org.nuxeo.vcs.query.log_min_duration_ms", (String)"-1")) * 1000000L;
    protected final Set<QueryResultContext> queryResults = new HashSet<QueryResultContext>();

    public SessionImpl(RepositoryImpl repository, Model model, Mapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
        this.model = model;
        this.context = new PersistenceContext(model, mapper, this);
        this.changeTokenEnabled = repository.isChangeTokenEnabled();
        this.fulltextDescriptor = repository.getRepositoryDescriptor().getFulltextDescriptor();
        this.readAclsChanged = false;
        this.saveTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "save", "timer"}).tagged(new String[]{"repository", repository.getName()}));
        this.queryTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "query", "timer"}).tagged(new String[]{"repository", repository.getName()}));
        this.aclrUpdateTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "aclr-update", "timer"}).tagged(new String[]{"repository", repository.getName()}));
        this.computeRootNode();
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    protected int clearCaches() {
        if (this.inTransaction) {
            return 0;
        }
        return this.context.clearCaches();
    }

    protected PersistenceContext getContext() {
        return this.context;
    }

    protected Serializable generateNewId(Serializable id) {
        return this.context.generateNewId(id);
    }

    protected boolean isIdNew(Serializable id) {
        return this.context.isIdNew(id);
    }

    @Override
    public void close() {
        try {
            this.closeSession();
        }
        finally {
            this.repository.closeSession(this);
        }
    }

    protected void closeSession() {
        this.context.clearCaches();
        this.mapper.close();
    }

    @Override
    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Node getRootNode() {
        return this.getNodeById(this.rootNodeId);
    }

    @Override
    public void save() {
        Timer.Context timerContext = this.saveTimer.time();
        try {
            this.flush();
            if (!this.inTransaction) {
                this.sendInvalidationsToOthers();
            }
            this.processReceivedInvalidations();
        }
        finally {
            timerContext.stop();
        }
    }

    protected void flush() {
        List<Object> works = !this.fulltextDescriptor.getFulltextDisabled() ? this.getFulltextWorks() : Collections.emptyList();
        this.doFlush();
        if (this.readAclsChanged) {
            this.updateReadAcls();
        }
        this.scheduleWork(works);
        this.checkInvalidationsConflict();
    }

    protected void scheduleWork(List<Work> works) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (repositoryManager != null && !works.isEmpty()) {
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            for (Work work : works) {
                workManager.schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFlush() {
        ArrayList<Fragment> fragmentsToClearDirty = new ArrayList<Fragment>(0);
        RowMapper.RowBatch batch = this.context.getSaveBatch(fragmentsToClearDirty);
        if (!batch.isEmpty()) {
            log.debug((Object)"Saving session");
            try {
                this.mapper.write(batch);
                log.debug((Object)"End of save");
            }
            finally {
                for (Fragment fragment : fragmentsToClearDirty) {
                    fragment.clearDirty();
                }
            }
        }
    }

    protected Serializable getContainingDocument(Serializable id) {
        return this.context.getContainingDocument(id);
    }

    protected List<Work> getFulltextWorks() {
        Set<Serializable> dirtyStrings = new HashSet<Serializable>();
        HashSet<Serializable> dirtyBinaries = new HashSet<Serializable>();
        this.context.findDirtyDocuments(dirtyStrings, dirtyBinaries);
        if (this.model.getFulltextConfiguration().fulltextSearchDisabled) {
            dirtyStrings = Collections.emptySet();
        }
        HashSet<Serializable> dirtyIds = new HashSet<Serializable>();
        dirtyIds.addAll(dirtyStrings);
        dirtyIds.addAll(dirtyBinaries);
        if (dirtyIds.isEmpty()) {
            return Collections.emptyList();
        }
        this.markIndexingInProgress(dirtyIds);
        ArrayList<Work> works = new ArrayList<Work>(dirtyIds.size());
        for (Serializable id : dirtyIds) {
            boolean updateSimpleText = dirtyStrings.contains(id);
            boolean updateBinaryText = dirtyBinaries.contains(id);
            FulltextExtractorWork work = new FulltextExtractorWork(this.repository.getName(), this.model.idToString(id), updateSimpleText, updateBinaryText, true);
            works.add((Work)work);
        }
        return works;
    }

    protected void markIndexingInProgress(Set<Serializable> dirtyIds) {
        FulltextConfiguration fulltextConfiguration = this.model.getFulltextConfiguration();
        for (Node node : this.getNodesByIds(dirtyIds)) {
            if (!fulltextConfiguration.isFulltextIndexable(node.getPrimaryType())) continue;
            node.getSimpleProperty("ecm:fulltextJobId").setValue(this.model.idToString(node.getId()));
        }
    }

    protected void sendInvalidationsToOthers() {
        this.context.sendInvalidationsToOthers();
    }

    protected void processReceivedInvalidations() {
        this.context.processReceivedInvalidations();
    }

    protected void checkInvalidationsConflict() {
        this.context.checkInvalidationsConflict();
    }

    protected Node getNodeById(Serializable id, boolean prefetch) {
        List<Node> nodes = this.getNodesByIds(Collections.singletonList(id), prefetch);
        Node node = nodes.get(0);
        return node;
    }

    @Override
    public Node getNodeById(Serializable id) {
        if (id == null) {
            throw new IllegalArgumentException("Illegal null id");
        }
        return this.getNodeById(id, true);
    }

    public List<Node> getNodesByIds(Collection<Serializable> ids, boolean prefetch) {
        Serializable id;
        ArrayList<RowId> hierRowIds = new ArrayList<RowId>(ids.size());
        for (Serializable id2 : ids) {
            hierRowIds.add(new RowId("hierarchy", id2));
        }
        List<Fragment> hierFragments = this.context.getMulti(hierRowIds, false);
        HashMap<Serializable, String> paths = new HashMap<Serializable, String>();
        HashSet<Serializable> parentIds = new HashSet<Serializable>();
        for (Fragment fragment : hierFragments) {
            id = fragment.getId();
            PersistenceContext.PathAndId pathAndId = this.context.getPathOrMissingParentId((SimpleFragment)fragment, false);
            if (pathAndId.path != null) {
                paths.put(id, pathAndId.path);
                continue;
            }
            parentIds.add(pathAndId.id);
        }
        if (!parentIds.isEmpty()) {
            this.getHierarchyAndAncestors(parentIds);
            for (Fragment fragment : hierFragments) {
                id = fragment.getId();
                if (paths.containsKey(id)) continue;
                String string = this.context.getPath((SimpleFragment)fragment);
                paths.put(id, string);
            }
        }
        HashMap<Serializable, FragmentGroup> fragmentGroups = new HashMap<Serializable, FragmentGroup>(ids.size());
        for (Fragment fragment : hierFragments) {
            Serializable serializable = fragment.row.id;
            fragmentGroups.put(serializable, new FragmentGroup((SimpleFragment)fragment, new FragmentsMap()));
        }
        if (prefetch) {
            ArrayList<RowId> arrayList = new ArrayList<RowId>();
            HashSet<Serializable> proxyIds = new HashSet<Serializable>();
            for (Fragment fragment : hierFragments) {
                this.findPrefetchedFragments((SimpleFragment)fragment, arrayList, proxyIds);
            }
            ArrayList<RowId> arrayList2 = new ArrayList<RowId>(proxyIds.size());
            for (Serializable id4 : proxyIds) {
                arrayList2.add(new RowId("proxies", id4));
            }
            List<Fragment> list = this.context.getMulti(arrayList2, true);
            HashSet<Serializable> targetIds = new HashSet<Serializable>();
            for (Fragment fragment : list) {
                Serializable targetId = ((SimpleFragment)fragment).get("targetid");
                targetIds.add(targetId);
            }
            targetIds.removeAll(ids);
            hierRowIds = new ArrayList(targetIds.size());
            for (Serializable id5 : targetIds) {
                hierRowIds.add(new RowId("hierarchy", id5));
            }
            hierFragments = this.context.getMulti(hierRowIds, true);
            for (Fragment fragment : hierFragments) {
                this.findPrefetchedFragments((SimpleFragment)fragment, arrayList, null);
            }
            List<Fragment> fragments = this.context.getMulti(arrayList, true);
            for (Fragment fragment : fragments) {
                FragmentGroup fragmentGroup = (FragmentGroup)fragmentGroups.get(fragment.row.id);
                if (fragmentGroup == null) continue;
                fragmentGroup.fragments.put(fragment.row.tableName, fragment);
            }
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(ids.size());
        for (Serializable serializable : ids) {
            FragmentGroup fragmentGroup = (FragmentGroup)fragmentGroups.get(serializable);
            Node node = fragmentGroup == null ? null : new Node(this.context, fragmentGroup, (String)paths.get(serializable));
            arrayList.add(node);
        }
        return arrayList;
    }

    protected void findPrefetchedFragments(SimpleFragment hierFragment, List<RowId> bulkRowIds, Set<Serializable> proxyIds) {
        Serializable id = hierFragment.row.id;
        String typeName = (String)((Object)hierFragment.get("primarytype"));
        if ("ecm:proxy".equals(typeName)) {
            if (proxyIds != null) {
                proxyIds.add(id);
            }
            return;
        }
        Set<String> tableNames = this.model.getTypePrefetchedFragments(typeName);
        if (tableNames == null) {
            return;
        }
        Serializable parentId = hierFragment.get("parentid");
        for (String tableName : tableNames) {
            if ("hierarchy".equals(tableName) || parentId != null && "versions".equals(tableName)) continue;
            bulkRowIds.add(new RowId(tableName, id));
        }
    }

    @Override
    public List<Node> getNodesByIds(Collection<Serializable> ids) {
        return this.getNodesByIds(ids, true);
    }

    @Override
    public Node getParentNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Illegal null node");
        }
        Serializable id = node.getHierFragment().get("parentid");
        return id == null ? null : this.getNodeById(id);
    }

    @Override
    public String getPath(Node node) {
        String path = node.getPath();
        if (path == null) {
            path = this.context.getPath(node.getHierFragment());
        }
        return path;
    }

    protected String normalize(String path) {
        return Normalizer.normalize(path, Normalizer.Form.NFC);
    }

    @Override
    public Node getNodeByPath(String path, Node node) {
        int i;
        if (path == null) {
            throw new IllegalArgumentException("Illegal null path");
        }
        if ((path = this.normalize(path)).startsWith("/")) {
            node = this.getRootNode();
            if (path.equals("/")) {
                return node;
            }
            i = 1;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("Illegal relative path with null node: " + path);
            }
            i = 0;
        }
        String[] names = path.split("/", -1);
        while (i < names.length) {
            String name = names[i];
            if (name.length() == 0) {
                throw new IllegalArgumentException("Illegal path with empty component: " + path);
            }
            if ((node = this.getChildNode(node, name, false)) == null) {
                return null;
            }
            ++i;
        }
        return node;
    }

    @Override
    public boolean addMixinType(Node node, String mixin) {
        if (this.model.getMixinPropertyInfos(mixin) == null) {
            throw new IllegalArgumentException("No such mixin: " + mixin);
        }
        if (this.model.getDocumentTypeFacets(node.getPrimaryType()).contains(mixin)) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(node.getMixinTypes()));
        if (list.contains(mixin)) {
            return false;
        }
        Set<String> otherChildrenNames = this.getChildrenNames(node.getPrimaryType(), list);
        list.add(mixin);
        String[] mixins = list.toArray(new String[list.size()]);
        node.hierFragment.put("mixintypes", (Serializable)mixins);
        Map<String, String> childrenTypes = this.model.getMixinComplexChildren(mixin);
        for (Map.Entry<String, String> es : childrenTypes.entrySet()) {
            String childName = es.getKey();
            String childType = es.getValue();
            if (otherChildrenNames.contains(childName)) continue;
            this.addChildNode(node, childName, null, childType, true);
        }
        return true;
    }

    @Override
    public boolean removeMixinType(Node node, String mixin) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(node.getMixinTypes()));
        if (!list.remove(mixin)) {
            return false;
        }
        String[] mixins = list.toArray(new String[list.size()]);
        if (mixins.length == 0) {
            mixins = null;
        }
        node.hierFragment.put("mixintypes", (Serializable)mixins);
        Set<String> otherChildrenNames = this.getChildrenNames(node.getPrimaryType(), list);
        Map<String, String> childrenTypes = this.model.getMixinComplexChildren(mixin);
        for (String childName : childrenTypes.keySet()) {
            if (otherChildrenNames.contains(childName)) continue;
            Node child = this.getChildNode(node, childName, true);
            this.removePropertyNode(child);
        }
        node.clearCache();
        return true;
    }

    @Override
    public ScrollResult<String> scroll(String query, int batchSize, int keepAliveSeconds) {
        return this.mapper.scroll(query, batchSize, keepAliveSeconds);
    }

    @Override
    public ScrollResult<String> scroll(String query, QueryFilter queryFilter, int batchSize, int keepAliveSeconds) {
        return this.mapper.scroll(query, queryFilter, batchSize, keepAliveSeconds);
    }

    @Override
    public ScrollResult<String> scroll(String scrollId) {
        return this.mapper.scroll(scrollId);
    }

    protected Set<String> getChildrenNames(String primaryType, List<String> mixins) {
        Map<String, String> cc = this.model.getTypeComplexChildren(primaryType);
        if (cc == null) {
            cc = Collections.emptyMap();
        }
        HashSet<String> childrenNames = new HashSet<String>(cc.keySet());
        for (String mixin : mixins) {
            cc = this.model.getMixinComplexChildren(mixin);
            if (cc == null) continue;
            childrenNames.addAll(cc.keySet());
        }
        return childrenNames;
    }

    @Override
    public Node addChildNode(Node parent, String name, Long pos, String typeName, boolean complexProp) {
        if (pos == null && !complexProp && parent != null) {
            pos = this.context.getNextPos(parent.getId(), complexProp);
        }
        return this.addChildNode(null, parent, name, pos, typeName, complexProp);
    }

    @Override
    public Node addChildNode(Serializable id, Node parent, String name, Long pos, String typeName, boolean complexProp) {
        if (name == null) {
            throw new IllegalArgumentException("Illegal null name");
        }
        if ((name = this.normalize(name)).contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        if (!this.model.isType(typeName)) {
            throw new IllegalArgumentException("Unknown type: " + typeName);
        }
        id = this.generateNewId(id);
        Serializable parentId = parent == null ? null : parent.hierFragment.getId();
        Node node = this.addNode(id, parentId, name, pos, typeName, complexProp);
        Map<String, String> childrenTypes = this.model.getTypeComplexChildren(typeName);
        for (Map.Entry<String, String> es : childrenTypes.entrySet()) {
            String childName = es.getKey();
            String childType = es.getValue();
            this.addChildNode(node, childName, null, childType, true);
        }
        return node;
    }

    protected Node addNode(Serializable id, Serializable parentId, String name, Long pos, String typeName, boolean complexProp) {
        this.requireReadAclsUpdate();
        Row hierRow = new Row("hierarchy", id);
        hierRow.putNew("parentid", parentId);
        hierRow.putNew("name", (Serializable)((Object)name));
        hierRow.putNew("pos", pos);
        hierRow.putNew("primarytype", (Serializable)((Object)typeName));
        hierRow.putNew("isproperty", Boolean.valueOf(complexProp));
        if (this.changeTokenEnabled) {
            hierRow.putNew("systemchangetoken", Model.INITIAL_SYS_CHANGE_TOKEN);
        }
        SimpleFragment hierFragment = this.context.createHierarchyFragment(hierRow);
        FragmentGroup fragmentGroup = new FragmentGroup(hierFragment, new FragmentsMap());
        return new Node(this.context, fragmentGroup, this.context.getPath(hierFragment));
    }

    @Override
    public Node addProxy(Serializable targetId, Serializable versionableId, Node parent, String name, Long pos) {
        if (!this.repository.getRepositoryDescriptor().getProxiesEnabled()) {
            throw new NuxeoException("Proxies are disabled by configuration");
        }
        Node proxy = this.addChildNode(parent, name, pos, "ecm:proxy", false);
        proxy.setSimpleProperty("ecm:proxyTargetId", targetId);
        proxy.setSimpleProperty("ecm:proxyVersionableId", versionableId);
        if (this.changeTokenEnabled) {
            proxy.setSimpleProperty("ecm:systemChangeToken", Model.INITIAL_SYS_CHANGE_TOKEN);
            proxy.setSimpleProperty("ecm:changeToken", Model.INITIAL_CHANGE_TOKEN);
        }
        SimpleFragment proxyFragment = (SimpleFragment)proxy.fragments.get("proxies");
        this.context.createdProxyFragment(proxyFragment);
        return proxy;
    }

    @Override
    public void setProxyTarget(Node proxy, Serializable targetId) {
        if (!this.repository.getRepositoryDescriptor().getProxiesEnabled()) {
            throw new NuxeoException("Proxies are disabled by configuration");
        }
        SimpleProperty prop = proxy.getSimpleProperty("ecm:proxyTargetId");
        Serializable oldTargetId = prop.getValue();
        if (!oldTargetId.equals(targetId)) {
            SimpleFragment proxyFragment = (SimpleFragment)proxy.fragments.get("proxies");
            this.context.removedProxyTarget(proxyFragment);
            proxy.setSimpleProperty("ecm:proxyTargetId", targetId);
            this.context.addedProxyTarget(proxyFragment);
        }
    }

    @Override
    public boolean hasChildNode(Node parent, String name, boolean complexProp) {
        SimpleFragment fragment = this.context.getChildHierByName(parent.getId(), this.normalize(name), complexProp);
        return fragment != null;
    }

    @Override
    public Node getChildNode(Node parent, String name, boolean complexProp) {
        if (name == null || name.contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        SimpleFragment fragment = this.context.getChildHierByName(parent.getId(), name, complexProp);
        return fragment == null ? null : this.getNodeById(fragment.getId());
    }

    @Override
    public boolean hasChildren(Node parent, boolean complexProp) {
        List<SimpleFragment> children = this.context.getChildren(parent.getId(), null, complexProp);
        if (complexProp) {
            return !children.isEmpty();
        }
        if (children.isEmpty()) {
            return false;
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        for (SimpleFragment simpleFragment : children) {
            DocumentType type;
            String primaryType = simpleFragment.getString("primarytype");
            if (primaryType.equals("ecm:proxy")) {
                Node target;
                Node node = this.getNodeById(simpleFragment.getId(), false);
                Serializable targetId = node.getSimpleProperty("ecm:proxyTargetId").getValue();
                if (targetId == null || (target = this.getNodeById(targetId, false)) == null) continue;
                primaryType = target.getPrimaryType();
            }
            if ((type = schemaManager.getDocumentType(primaryType)) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node> getChildren(Node parent, String name, boolean complexProp) {
        List<SimpleFragment> fragments = this.context.getChildren(parent.getId(), name, complexProp);
        ArrayList<Node> nodes = new ArrayList<Node>(fragments.size());
        for (SimpleFragment fragment : fragments) {
            Node node = this.getNodeById(fragment.getId());
            if (node == null) {
                log.error((Object)("Child node cannot be created: " + fragment.getId()));
                continue;
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void orderBefore(Node parent, Node source, Node dest) {
        this.context.orderBefore(parent.getId(), source.getId(), dest == null ? null : dest.getId());
    }

    @Override
    public Node move(Node source, Node parent, String name) {
        if (!parent.getId().equals(source.getParentId())) {
            this.flush();
        }
        this.context.move(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return source;
    }

    @Override
    public Node copy(Node source, Node parent, String name, Consumer<Node> afterRecordCopy) {
        this.flush();
        Consumer<Serializable> afterRecordCopyWithId = afterRecordCopy == null ? null : recId -> afterRecordCopy.accept(this.getNodeById((Serializable)recId));
        Serializable id = this.context.copy(source, parent.getId(), name, afterRecordCopyWithId);
        this.requireReadAclsUpdate();
        return this.getNodeById(id);
    }

    @Override
    public void removeNode(Node node, Consumer<Node> beforeRecordRemove) {
        boolean allowDeleteUndeletable;
        this.flush();
        Serializable id = node.getId();
        this.getLockManager().removeLock(this.model.idToString(id), null);
        List<RowMapper.NodeInfo> nodeInfos = this.context.getNodeAndDescendantsInfo(node.getHierFragment());
        Set undeletableIds = nodeInfos.stream().filter(info -> info.isUndeletable).map(info -> info.id).collect(Collectors.toSet());
        if (!undeletableIds.isEmpty() && !(allowDeleteUndeletable = Framework.isBooleanPropertyTrue((String)"org.nuxeo.core.allowDeleteUndeletableDocuments"))) {
            if (undeletableIds.contains(id)) {
                throw new DocumentExistsException("Cannot remove " + id + ", it is under retention / hold");
            }
            throw new DocumentExistsException("Cannot remove " + id + ", subdocument " + undeletableIds.iterator().next() + " is under retention / hold");
        }
        if (beforeRecordRemove != null) {
            nodeInfos.stream().filter(info -> info.isRecord).map(info -> this.getNodeById(info.id)).forEach(beforeRecordRemove::accept);
        }
        if (this.repository.getRepositoryDescriptor().getProxiesEnabled()) {
            Set<Serializable> removedIds = nodeInfos.stream().map(info -> info.id).collect(Collectors.toSet());
            Set<Serializable> proxyIds = this.context.getTargetProxies(removedIds);
            for (Serializable proxyId : proxyIds) {
                if (removedIds.contains(proxyId)) continue;
                Node proxy = this.getNodeById(proxyId);
                Serializable targetId = (Serializable)proxy.getSingle("ecm:proxyTargetId");
                throw new DocumentExistsException("Cannot remove " + id + ", subdocument " + targetId + " is the target of proxy " + proxyId);
            }
        }
        this.context.removeNode(node.getHierFragment(), nodeInfos);
    }

    @Override
    public void removePropertyNode(Node node) {
        this.context.removePropertyNode(node.getHierFragment());
    }

    @Override
    public Node checkIn(Node node, String label, String checkinComment) {
        this.flush();
        Serializable id = this.context.checkIn(node, label, checkinComment);
        this.requireReadAclsUpdate();
        this.flush();
        return this.getNodeById(id);
    }

    @Override
    public void checkOut(Node node) {
        this.context.checkOut(node);
        this.requireReadAclsUpdate();
    }

    @Override
    public void restore(Node node, Node version) {
        this.context.restoreVersion(node, version);
        this.requireReadAclsUpdate();
    }

    @Override
    public Node getVersionByLabel(Serializable versionSeriesId, String label) {
        if (label == null) {
            return null;
        }
        List<Node> versions = this.getVersions(versionSeriesId);
        for (Node node : versions) {
            String l = (String)((Object)node.getSimpleProperty("ecm:versionLabel").getValue());
            if (!label.equals(l)) continue;
            return node;
        }
        return null;
    }

    @Override
    public Node getLastVersion(Serializable versionSeriesId) {
        List<Serializable> ids = this.context.getVersionIds(versionSeriesId);
        return ids.isEmpty() ? null : this.getNodeById(ids.get(ids.size() - 1));
    }

    @Override
    public List<Node> getVersions(Serializable versionSeriesId) {
        List<Serializable> ids = this.context.getVersionIds(versionSeriesId);
        ArrayList<Node> nodes = new ArrayList<Node>(ids.size());
        for (Serializable id : ids) {
            nodes.add(this.getNodeById(id));
        }
        return nodes;
    }

    @Override
    public List<Node> getProxies(Node document, Node parent) {
        List<Serializable> ids;
        if (!this.repository.getRepositoryDescriptor().getProxiesEnabled()) {
            return Collections.emptyList();
        }
        if (document.isVersion()) {
            ids = this.context.getTargetProxyIds(document.getId());
        } else {
            Serializable versionSeriesId = document.isProxy() ? document.getSimpleProperty("ecm:proxyVersionableId").getValue() : document.getId();
            ids = this.context.getSeriesProxyIds(versionSeriesId);
        }
        List<Node> nodes = this.getNodes(ids);
        if (parent != null) {
            Serializable parentId = parent.getId();
            nodes.removeIf(node -> !parentId.equals(node.getParentId()));
        }
        return nodes;
    }

    protected List<Node> getNodes(List<Serializable> ids) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Serializable id : ids) {
            Node node = this.getNodeById(id);
            if (node == null && !Boolean.TRUE.booleanValue()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public List<Node> getProxies(Node document) {
        if (!this.repository.getRepositoryDescriptor().getProxiesEnabled()) {
            return Collections.emptyList();
        }
        List<Serializable> ids = this.context.getTargetProxyIds(document.getId());
        return this.getNodes(ids);
    }

    protected List<Fragment> getHierarchyAndAncestors(Collection<Serializable> ids) {
        Set<Serializable> allIds = this.mapper.getAncestorsIds(ids);
        allIds.addAll(ids);
        ArrayList<RowId> rowIds = new ArrayList<RowId>(allIds.size());
        for (Serializable id : allIds) {
            rowIds.add(new RowId("hierarchy", id));
        }
        return this.context.getMulti(rowIds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialList<Serializable> query(String query, QueryFilter queryFilter, boolean countTotal) {
        Timer.Context timerContext = this.queryTimer.time();
        try {
            PartialList<Serializable> partialList = this.mapper.query(query, "NXQL", queryFilter, countTotal);
            return partialList;
        }
        finally {
            timerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) {
        PartialList<Serializable> partialList;
        Timer.Context timerContext = this.queryTimer.time();
        try {
            partialList = this.mapper.query(query, queryType, queryFilter, countUpTo);
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
                String msg = String.format("duration_ms:\t%.2f\t%s %s\tquery\t%s", (double)duration / 1000000.0, queryFilter, this.countUpToAsString(countUpTo), query);
                if (log.isTraceEnabled()) {
                    log.info((Object)msg, new Throwable("Slow query stack trace"));
                } else {
                    log.info((Object)msg);
                }
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
            String msg = String.format("duration_ms:\t%.2f\t%s %s\tquery\t%s", (double)duration / 1000000.0, queryFilter, this.countUpToAsString(countUpTo), query);
            if (log.isTraceEnabled()) {
                log.info((Object)msg, new Throwable("Slow query stack trace"));
            } else {
                log.info((Object)msg);
            }
        }
        return partialList;
    }

    private String countUpToAsString(long countUpTo) {
        if (countUpTo > 0L) {
            return String.format("count total results up to %d", countUpTo);
        }
        return countUpTo == -1L ? "count total results UNLIMITED" : "";
    }

    protected void noteQueryResult(IterableQueryResult result) {
        this.queryResults.add(new QueryResultContext(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeQueryResults() {
        for (QueryResultContext ctx : this.queryResults) {
            if (!ctx.queryResult.mustBeClosed()) continue;
            try {
                ctx.queryResult.close();
            }
            catch (RuntimeException e) {
                log.error((Object)"Cannot close query result", (Throwable)e);
            }
            finally {
                log.warn((Object)"Closing a query results for you, check stack trace for allocating point", (Throwable)ctx);
            }
        }
        this.queryResults.clear();
    }

    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) {
        return this.queryAndFetch(query, queryType, queryFilter, false, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, Object ... params) {
        IterableQueryResult iterableQueryResult;
        Timer.Context timerContext = this.queryTimer.time();
        try {
            IterableQueryResult result = this.mapper.queryAndFetch(query, queryType, queryFilter, distinctDocuments, params);
            this.noteQueryResult(result);
            iterableQueryResult = result;
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
                String msg = String.format("duration_ms:\t%.2f\t%s\tqueryAndFetch\t%s", (double)duration / 1000000.0, queryFilter, query);
                if (log.isTraceEnabled()) {
                    log.info((Object)msg, new Throwable("Slow query stack trace"));
                } else {
                    log.info((Object)msg);
                }
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
            String msg = String.format("duration_ms:\t%.2f\t%s\tqueryAndFetch\t%s", (double)duration / 1000000.0, queryFilter, query);
            if (log.isTraceEnabled()) {
                log.info((Object)msg, new Throwable("Slow query stack trace"));
            } else {
                log.info((Object)msg);
            }
        }
        return iterableQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialList<Map<String, Serializable>> queryProjection(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, long countUpTo, Object ... params) {
        PartialList<Map<String, Serializable>> partialList;
        Timer.Context timerContext = this.queryTimer.time();
        try {
            partialList = this.mapper.queryProjection(query, queryType, queryFilter, distinctDocuments, countUpTo, params);
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
                String msg = String.format("duration_ms:\t%.2f\t%s\tqueryProjection\t%s", (double)duration / 1000000.0, queryFilter, query);
                if (log.isTraceEnabled()) {
                    log.info((Object)msg, new Throwable("Slow query stack trace"));
                } else {
                    log.info((Object)msg);
                }
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
            String msg = String.format("duration_ms:\t%.2f\t%s\tqueryProjection\t%s", (double)duration / 1000000.0, queryFilter, query);
            if (log.isTraceEnabled()) {
                log.info((Object)msg, new Throwable("Slow query stack trace"));
            } else {
                log.info((Object)msg);
            }
        }
        return partialList;
    }

    @Override
    public LockManager getLockManager() {
        return this.repository.getLockManager();
    }

    @Override
    public void requireReadAclsUpdate() {
        this.readAclsChanged = true;
    }

    @Override
    public void updateReadAcls() {
        Timer.Context timerContext = this.aclrUpdateTimer.time();
        try {
            this.mapper.updateReadAcls();
            this.readAclsChanged = false;
        }
        finally {
            timerContext.stop();
        }
    }

    @Override
    public void rebuildReadAcls() {
        this.mapper.rebuildReadAcls();
        this.readAclsChanged = false;
    }

    private void computeRootNode() {
        String repositoryId = this.repository.getName();
        Serializable rootId = this.mapper.getRootId(repositoryId);
        if (rootId == null && COMPAT_REPOSITORY_NAME) {
            rootId = this.mapper.getRootId("default");
        }
        if (rootId == null) {
            log.debug((Object)"Creating root");
            this.addRootNode();
            this.save();
            this.mapper.setRootId((Serializable)((Object)repositoryId), this.rootNodeId);
        } else {
            this.rootNodeId = rootId;
        }
    }

    private Node addRootNode() {
        this.rootNodeId = this.generateNewId(null);
        Node rootNode = this.addNode(this.rootNodeId, null, "", null, "Root", false);
        this.addRootACP(rootNode);
        return rootNode;
    }

    private void addRootACP(Node rootNode) {
        Object[] aclrows = new ACLRow[]{new ACLRow(0, "local", true, "Everything", "administrators", null), new ACLRow(1, "local", true, "Everything", "Administrator", null), new ACLRow(2, "local", true, "Read", "members", null)};
        rootNode.setCollectionProperty("ecm:acl", aclrows);
        this.requireReadAclsUpdate();
    }

    public void markReferencedBinaries() {
        this.mapper.markReferencedBinaries();
    }

    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        if (!this.repository.getRepositoryDescriptor().getSoftDeleteEnabled()) {
            return 0;
        }
        return this.mapper.cleanupDeletedRows(max, beforeTime);
    }

    public void start() {
        this.inTransaction = true;
        this.processReceivedInvalidations();
    }

    public void end() {
        this.closeQueryResults();
        try {
            this.flush();
        }
        catch (ConcurrentUpdateException e) {
            TransactionHelper.setTransactionRollbackOnly();
            throw e;
        }
    }

    public void commit() {
        try {
            this.sendInvalidationsToOthers();
        }
        finally {
            this.inTransaction = false;
        }
    }

    public void rollback() {
        try {
            try {
                this.mapper.rollback();
            }
            finally {
                this.context.clearCaches();
            }
        }
        finally {
            this.inTransaction = false;
        }
    }

    public long getCacheSize() {
        return this.context.getCacheSize();
    }

    public long getCacheMapperSize() {
        return this.context.getCacheMapperSize();
    }

    public long getCachePristineSize() {
        return this.context.getCachePristineSize();
    }

    public long getCacheSelectionSize() {
        return this.context.getCacheSelectionSize();
    }

    @Override
    public boolean isFulltextStoredInBlob() {
        return this.fulltextDescriptor.getFulltextStoredInBlob();
    }

    @Override
    public Map<String, String> getBinaryFulltext(Serializable id, Document doc) {
        if (this.fulltextDescriptor.getFulltextDisabled()) {
            return null;
        }
        RowId rowId = new RowId("fulltext", id);
        Map<String, String> map = this.mapper.getBinaryFulltext(rowId);
        String fulltext = map.get("binarytext");
        if (this.fulltextDescriptor.getFulltextStoredInBlob() && fulltext != null) {
            if (doc == null) {
                fulltext = null;
            } else {
                DocumentBlobManager blobManager = (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
                try {
                    BlobInfo blobInfo = new BlobInfo();
                    blobInfo.key = fulltext;
                    String xpath = "ecm:fulltextBinary";
                    Blob blob = blobManager.readBlob(blobInfo, doc, xpath);
                    fulltext = blob.getString();
                }
                catch (IOException e) {
                    throw new PropertyException("Cannot read fulltext blob for doc: " + id, (Throwable)e);
                }
            }
            map.put("binarytext", fulltext);
        }
        return map;
    }

    @Override
    public boolean isChangeTokenEnabled() {
        return this.changeTokenEnabled;
    }

    @Override
    public void markUserChange(Serializable id) {
        this.context.markUserChange(id);
    }

    protected static class QueryResultContext
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final IterableQueryResult queryResult;

        public QueryResultContext(IterableQueryResult queryResult) {
            super("queryAndFetch call context");
            this.queryResult = queryResult;
        }
    }
}

