/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.LockException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.runtime.datasource.ConnectionHelper;

public class VCSLockManager
implements LockManager {
    private static final Logger log = LogManager.getLogger(VCSLockManager.class);
    public static final int LOCK_RETRIES = 10;
    public static final long LOCK_SLEEP_DELAY = 1L;
    public static final long LOCK_SLEEP_INCREMENT = 50L;
    protected final String dataSourceName;
    protected final Model model;
    protected final SQLInfo sqlInfo;

    public VCSLockManager(RepositoryImpl repository) {
        this.dataSourceName = "repository_" + repository.getName();
        this.model = repository.getModel();
        this.sqlInfo = repository.getSQLInfo();
    }

    protected Connection getConnection() throws SQLException {
        return ConnectionHelper.getConnection((String)this.dataSourceName, (boolean)true);
    }

    protected Serializable idFromString(String id) {
        return this.model.idFromString(id);
    }

    public Lock getLock(String id) {
        return this.readLock(this.idFromString(id));
    }

    public Lock setLock(String id, Lock lock) {
        ArrayList<NuxeoException> suppressed = new ArrayList<NuxeoException>(0);
        long sleepDelay = 1L;
        for (int i = 0; i < 10; ++i) {
            if (i > 0) {
                log.debug("Retrying lock on {}: try {}", (Object)id, (Object)(i + 1));
            }
            try {
                return this.writeLock(this.idFromString(id), lock);
            }
            catch (NuxeoException e) {
                suppressed.add(e);
                if (this.shouldRetry((Exception)((Object)e))) {
                    try {
                        Thread.sleep(sleepDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(interruptedException);
                    }
                    sleepDelay += 50L;
                    continue;
                }
                NuxeoException nuxeoException = new NuxeoException((Throwable)e);
                for (Throwable throwable : suppressed) {
                    nuxeoException.addSuppressed(throwable);
                }
                throw nuxeoException;
            }
        }
        LockException exception = new LockException("Failed to lock " + id + ", too much concurrency (tried 10 times)");
        for (Throwable throwable : suppressed) {
            exception.addSuppressed(throwable);
        }
        throw exception;
    }

    protected void checkConcurrentUpdate(Throwable e) {
        if (this.sqlInfo.dialect.isConcurrentUpdateException(e)) {
            log.debug((Object)e, e);
            throw new ConcurrentUpdateException("Concurrent update", e);
        }
    }

    protected boolean shouldRetry(Exception e) {
        if (e instanceof ConcurrentUpdateException) {
            return true;
        }
        Throwable t = e.getCause();
        if (t instanceof BatchUpdateException && t.getCause() != null) {
            t = t.getCause();
        }
        return t instanceof SQLException && this.shouldRetry((SQLException)t);
    }

    protected boolean shouldRetry(SQLException e) {
        String sqlState = e.getSQLState();
        if ("23000".equals(sqlState)) {
            return true;
        }
        if ("23001".equals(sqlState)) {
            return true;
        }
        if ("23505".equals(sqlState)) {
            return true;
        }
        return "S0003".equals(sqlState) || "S0005".equals(sqlState);
    }

    public Lock removeLock(String id, String owner) {
        return this.deleteLock(this.idFromString(id), owner);
    }

    protected Lock readLock(Serializable id) {
        Lock lock;
        block8: {
            Connection connection = this.getConnection();
            try {
                lock = this.readLock0(connection, id);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.checkConcurrentUpdate(e);
                    throw new NuxeoException((Throwable)e);
                }
            }
            connection.close();
        }
        return lock;
    }

    protected Lock readLock0(Connection connection, Serializable id) throws SQLException {
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectFragmentById.get("locks");
        try (PreparedStatement ps = connection.prepareStatement(select.sql);){
            Lock lock;
            block21: {
                ResultSet rs;
                block19: {
                    Column column2;
                    block20: {
                        for (Column column2 : select.whereColumns) {
                            String key = column2.getKey();
                            if ("id".equals(key)) {
                                column2.setToPreparedStatement(ps, 1, id);
                                continue;
                            }
                            throw new NuxeoException(key);
                        }
                        log.trace("SQL: {} id={}", (Object)select.sql, (Object)id);
                        rs = ps.executeQuery();
                        if (rs.next()) break block19;
                        log.trace("SQL:   -> null");
                        column2 = null;
                        if (rs == null) break block20;
                        rs.close();
                    }
                    return column2;
                }
                try {
                    String owner = null;
                    Calendar created = null;
                    int i = 1;
                    for (Column column : select.whatColumns) {
                        String key = column.getKey();
                        Serializable value = column.getFromResultSet(rs, i++);
                        if ("owner".equals(key)) {
                            owner = (String)((Object)value);
                            continue;
                        }
                        if ("created".equals(key)) {
                            created = (Calendar)value;
                            continue;
                        }
                        throw new NuxeoException(key);
                    }
                    log.trace("SQL:   -> {}", owner);
                    lock = new Lock(owner, created);
                    if (rs == null) break block21;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return lock;
        }
    }

    protected Lock writeLock(Serializable id, Lock lock) {
        Lock lock2;
        block8: {
            Connection connection = this.getConnection();
            try {
                lock2 = this.writeLock(connection, id, lock);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.checkConcurrentUpdate(e);
                    throw new NuxeoException((Throwable)e);
                }
            }
            connection.close();
        }
        return lock2;
    }

    protected Lock writeLock(Connection connection, Serializable id, Lock lock) throws SQLException {
        try {
            this.writeLock0(connection, id, lock);
            return null;
        }
        catch (SQLException e) {
            if (!this.sqlInfo.dialect.isConcurrentUpdateException(e)) {
                throw e;
            }
            log.trace("SQL:   -> duplicate");
            Lock oldLock = this.readLock0(connection, id);
            if (oldLock != null) {
                return oldLock;
            }
            throw new ConcurrentUpdateException("Concurrent update");
        }
    }

    protected void writeLock0(Connection connection, Serializable id, Lock lock) throws SQLException {
        String sql = this.sqlInfo.getInsertSql("locks");
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            int i = 1;
            for (Column column : this.sqlInfo.getInsertColumns("locks")) {
                Object value;
                String key = column.getKey();
                if ("id".equals(key)) {
                    value = id;
                } else if ("owner".equals(key)) {
                    value = lock.getOwner();
                } else if ("created".equals(key)) {
                    value = lock.getCreated();
                } else {
                    throw new NuxeoException(key);
                }
                column.setToPreparedStatement(ps, i++, (Serializable)value);
            }
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> sql;
            supplierArray[1] = () -> id;
            supplierArray[2] = () -> ((Lock)lock).getOwner();
            log.trace("SQL: {} id={} owner={}", supplierArray);
            ps.execute();
        }
    }

    protected Lock deleteLock(Serializable id, String owner) {
        Lock lock;
        block8: {
            Connection connection = this.getConnection();
            try {
                lock = this.deleteLock(connection, id, owner);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.checkConcurrentUpdate(e);
                    throw new NuxeoException((Throwable)e);
                }
            }
            connection.close();
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock deleteLock(Connection connection, Serializable id, String owner) throws SQLException {
        log.trace("SQL: tx begin");
        connection.setAutoCommit(false);
        try {
            Lock oldLock = this.readLock0(connection, id);
            if (owner != null) {
                if (oldLock == null) {
                    Lock lock = null;
                    return lock;
                }
                if (!LockManager.canLockBeRemoved((String)oldLock.getOwner(), (String)owner)) {
                    Lock lock = new Lock(oldLock, true);
                    return lock;
                }
            }
            if (oldLock != null) {
                this.deleteLock0(connection, id);
            }
            Lock lock = oldLock;
            return lock;
        }
        finally {
            try {
                log.trace("SQL: tx commit");
                connection.commit();
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
    }

    protected void deleteLock0(Connection connection, Serializable id) throws SQLException {
        String sql = this.sqlInfo.getDeleteSql("locks", 1);
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            log.trace("SQL: {} id={}", (Object)sql, (Object)id);
            this.sqlInfo.dialect.setId(ps, 1, id);
            ps.executeUpdate();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.dataSourceName + ")";
    }
}

