/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.SQLStatement;

public class TableUpgrader {
    protected List<TableUpgrade> tableUpgrades = new ArrayList<TableUpgrade>();
    private SQLInfo sqlInfo;
    private Connection connection;
    private JDBCLogger logger;
    private static final Log log = LogFactory.getLog(TableUpgrader.class);

    public TableUpgrader(SQLInfo sqlInfo, Connection connection, JDBCLogger logger) {
        this.sqlInfo = sqlInfo;
        this.connection = connection;
        this.logger = logger;
    }

    public void add(String tableKey, String columnName, String sqlProcedure, String testProp) {
        this.tableUpgrades.add(new TableUpgrade(tableKey, columnName, sqlProcedure, testProp));
    }

    public void upgrade(String tableKey, List<Column> addedColumns, String ddlMode, SQLStatement.ListCollector ddlCollector) throws SQLException {
        for (TableUpgrade upgrade : this.tableUpgrades) {
            boolean doUpgrade;
            if (!upgrade.tableKey.equals(tableKey)) continue;
            if (addedColumns == null) {
                doUpgrade = RepositoryImpl.testProps.containsKey(upgrade.testProp);
            } else {
                doUpgrade = false;
                for (Column col : addedColumns) {
                    if (!col.getKey().equals(upgrade.columnName)) continue;
                    doUpgrade = true;
                    break;
                }
            }
            if (!doUpgrade) continue;
            log.info((Object)("Upgrading table: " + tableKey));
            this.sqlInfo.executeSQLStatements(upgrade.sqlProcedure, ddlMode, this.connection, this.logger, ddlCollector);
        }
    }

    protected static class TableUpgrade {
        public final String tableKey;
        public final String columnName;
        public final String sqlProcedure;
        public final String testProp;

        public TableUpgrade(String tableKey, String columnName, String sqlProcedure, String testProp) {
            this.tableKey = tableKey;
            this.columnName = columnName;
            this.sqlProcedure = sqlProcedure;
            this.testProp = testProp;
        }
    }
}

