/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.model.BaseSession;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;

public class DialectH2
extends Dialect {
    protected static final String DEFAULT_USERS_SEPARATOR = ",";
    protected final String usersSeparator;
    protected final boolean disableVersionACL;
    protected final boolean disableReadVersionPermission;

    public DialectH2(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) {
        super(metadata, repositoryDescriptor);
        if (!this.fulltextSearchDisabled) {
            throw new NuxeoException("Fulltext search cannot be enabled with H2");
        }
        this.usersSeparator = repositoryDescriptor == null ? null : (repositoryDescriptor.usersSeparatorKey == null ? DEFAULT_USERS_SEPARATOR : repositoryDescriptor.usersSeparatorKey);
        this.disableVersionACL = BaseSession.VersionAclMode.getConfiguration() == BaseSession.VersionAclMode.DISABLED;
        this.disableReadVersionPermission = BaseSession.isReadVersionPermissionDisabled();
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectH2.jdbcInfo("VARCHAR", 12);
                }
                if (type.isClob()) {
                    return DialectH2.jdbcInfo("CLOB", 2005);
                }
                return DialectH2.jdbcInfo("VARCHAR(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectH2.jdbcInfo("BOOLEAN", 16);
            }
            case LONG: {
                return DialectH2.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return DialectH2.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return DialectH2.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return DialectH2.jdbcInfo("VARCHAR(250)", 12);
            }
            case BLOB: {
                return DialectH2.jdbcInfo("BLOB", 2004);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return DialectH2.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectH2.jdbcInfo("VARCHAR(250)", 12);
            }
            case TINYINT: {
                return DialectH2.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return DialectH2.jdbcInfo("INTEGER", 4);
            }
            case AUTOINC: {
                return DialectH2.jdbcInfo("INTEGER AUTO_INCREMENT", 4);
            }
            case FTINDEXED: {
                throw new AssertionError(type);
            }
            case FTSTORED: {
                return DialectH2.jdbcInfo("CLOB", 2005);
            }
            case CLUSTERNODE: {
                return DialectH2.jdbcInfo("INTEGER", 4);
            }
            case CLUSTERFRAGS: {
                return DialectH2.jdbcInfo("VARCHAR", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case 16: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: {
                ps.setLong(index, ((Number)value).longValue());
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
            case 2004: {
                ps.setBytes(index, (byte[])value);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                return this.getFromResultSetString(rs, index, column);
            }
            case 16: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
            case 2004: {
                return rs.getBytes(index);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 0;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return false;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        if (!inOrderBy) {
            return "CAST(%s AS VARCHAR)";
        }
        return null;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED2(%s, ?, ?, %s, %s)", idColumnName, this.disableVersionACL, this.disableReadVersionPermission);
    }

    @Override
    public String getInTreeSql(String idColumnName, String id) {
        return String.format("NX_IN_TREE(%s, ?)", idColumnName);
    }

    @Override
    public boolean supportsArrays() {
        return false;
    }

    @Override
    public String getUpsertSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues) {
        Column keyColumn = columns.get(0);
        Table table = keyColumn.getTable();
        StringBuilder sql = new StringBuilder();
        sql.append("MERGE INTO ");
        sql.append(table.getQuotedName());
        sql.append(" KEY (");
        sql.append(keyColumn.getQuotedName());
        sql.append(") VALUES (");
        for (int i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
            outColumns.add(columns.get(i));
            outValues.add(values.get(i));
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public boolean isConcurrentUpdateException(Throwable t) {
        Throwable cause;
        while ((cause = t.getCause()) != null && cause instanceof SQLException) {
            t = cause;
        }
        if (t instanceof SQLException) {
            String sqlState = ((SQLException)t).getSQLState();
            if ("23503".equals(sqlState)) {
                return true;
            }
            if ("23505".equals(sqlState)) {
                return true;
            }
            if ("23506".equals(sqlState)) {
                return true;
            }
            if ("40001".equals(sqlState)) {
                return true;
            }
            if ("HYT00".equals(sqlState)) {
                return true;
            }
            if ("90131".equals(sqlState)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/h2.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/h2.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"VARCHAR(36)"));
        String[] permissions = ((SecurityService)Framework.getService(SecurityService.class)).getPermissionsToCheck("Browse");
        LinkedList<CallSite> permsList = new LinkedList<CallSite>();
        for (String perm : permissions) {
            permsList.add((CallSite)((Object)("('" + perm + "')")));
        }
        properties.put("clusteringEnabled", Boolean.valueOf(this.clusteringEnabled));
        properties.put("readPermissions", (Serializable)((Object)String.join((CharSequence)", ", permsList)));
        properties.put("h2Functions", (Serializable)((Object)"org.nuxeo.ecm.core.storage.sql.db.H2Functions"));
        properties.put("usersSeparator", (Serializable)((Object)this.getUsersSeparator()));
        return properties;
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "CALL NX_CLUSTER_INVAL(?, ?, ?, ?)";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "SELECT * FROM NX_CLUSTER_GET_INVALS(?)";
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        return sql + String.format(" LIMIT %d OFFSET %d", limit, offset);
    }

    public String getUsersSeparator() {
        if (this.usersSeparator == null) {
            return DEFAULT_USERS_SEPARATOR;
        }
        return this.usersSeparator;
    }

    @Override
    public String getBlobLengthFunction() {
        return "LENGTH";
    }

    @Override
    public String getAncestorsIdsSql() {
        return "CALL NX_ANCESTORS(?)";
    }

    @Override
    public List<String> checkStoredProcedure(String procName, String procCreate, String ddlMode, Connection connection, JDBCLogger logger, Map<String, Serializable> properties) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

