/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.model.BaseSession;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.FulltextQueryAnalyzer;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;

public class DialectSQLServer
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectSQLServer.class);
    private static final String DEFAULT_FULLTEXT_ANALYZER = "english";
    private static final String DEFAULT_FULLTEXT_CATALOG = "nuxeo";
    public static final String CLUSTER_INDEX_COL = "_oid";
    protected final boolean noRepositoryDescriptor;
    protected final String fulltextAnalyzer;
    protected final String fulltextCatalog;
    private static final String DEFAULT_USERS_SEPARATOR = "|";
    protected final String usersSeparator;
    protected final Dialect.DialectIdType idType;
    protected String idSequenceName;
    protected boolean pathOptimizationsEnabled;
    protected final boolean disableVersionACL;
    protected final boolean disableReadVersionPermission;
    protected int majorVersion;
    protected int engineEdition;
    protected boolean azure;

    public DialectSQLServer(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) {
        super(metadata, repositoryDescriptor);
        String idt;
        this.noRepositoryDescriptor = repositoryDescriptor == null;
        try {
            this.checkDatabaseConfiguration(metadata.getConnection());
            this.majorVersion = metadata.getDatabaseMajorVersion();
            this.engineEdition = this.getEngineEdition(metadata.getConnection());
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (this.engineEdition == 5) {
            this.azure = true;
            this.fulltextDisabled = true;
            this.fulltextSearchDisabled = true;
            if (repositoryDescriptor != null) {
                repositoryDescriptor.setFulltextDisabled(true);
            }
        }
        String string = repositoryDescriptor == null ? null : (this.fulltextAnalyzer = repositoryDescriptor.getFulltextAnalyzer() == null ? DEFAULT_FULLTEXT_ANALYZER : repositoryDescriptor.getFulltextAnalyzer());
        String string2 = repositoryDescriptor == null ? null : (this.fulltextCatalog = repositoryDescriptor.getFulltextCatalog() == null ? DEFAULT_FULLTEXT_CATALOG : repositoryDescriptor.getFulltextCatalog());
        this.usersSeparator = repositoryDescriptor == null ? null : (repositoryDescriptor.usersSeparatorKey == null ? DEFAULT_USERS_SEPARATOR : repositoryDescriptor.usersSeparatorKey);
        this.pathOptimizationsEnabled = repositoryDescriptor != null && repositoryDescriptor.getPathOptimizationsEnabled();
        this.disableVersionACL = BaseSession.VersionAclMode.getConfiguration() == BaseSession.VersionAclMode.DISABLED;
        this.disableReadVersionPermission = BaseSession.isReadVersionPermissionDisabled();
        String string3 = idt = repositoryDescriptor == null ? null : repositoryDescriptor.idType;
        if (idt == null || "".equals(idt) || "varchar".equalsIgnoreCase(idt)) {
            this.idType = Dialect.DialectIdType.VARCHAR;
        } else if (idt.toLowerCase().startsWith("sequence")) {
            this.idType = Dialect.DialectIdType.SEQUENCE;
            if (idt.toLowerCase().startsWith("sequence:")) {
                String[] split = idt.split(":");
                this.idSequenceName = split[1];
            } else {
                this.idSequenceName = "hierarchy_seq";
            }
        } else {
            throw new NuxeoException("Unknown id type: '" + idt + "'");
        }
    }

    @Override
    public boolean supportsPaging() {
        return this.majorVersion >= 11;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        if (!((String)sql).contains("ORDER")) {
            sql = (String)sql + " ORDER BY 1";
        }
        return (String)sql + String.format(" OFFSET %d ROWS FETCH NEXT %d ROWS ONLY", offset, limit);
    }

    protected int getEngineEdition(Connection connection) throws SQLException {
        try (Statement st = connection.createStatement();){
            int n;
            block12: {
                ResultSet rs = st.executeQuery("SELECT CONVERT(NVARCHAR(100), SERVERPROPERTY('EngineEdition'))");
                try {
                    rs.next();
                    n = rs.getInt(1);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
    }

    protected void checkDatabaseConfiguration(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            String sql = "SELECT is_read_committed_snapshot_on FROM sys.databases WHERE name = db_name()";
            if (log.isTraceEnabled()) {
                log.trace((Object)("SQL: " + sql));
            }
            try (ResultSet rs = stmt.executeQuery(sql);){
                if (!rs.next()) {
                    throw new SQLException("Cannot detect whether READ_COMMITTED_SNAPSHOT is on");
                }
                int on = rs.getInt(1);
                if (on != 1 && !this.noRepositoryDescriptor) {
                    throw new SQLException("Incorrect database configuration, you must enable READ_COMMITTED_SNAPSHOT");
                }
            }
        }
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getNoColumnsInsertString(Column idColumn) {
        return "DEFAULT VALUES";
    }

    @Override
    public String getNullColumnString() {
        return " NULL";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectSQLServer.jdbcInfo("NVARCHAR(4000)", 12);
                }
                if (type.isClob() || type.length > 4000) {
                    return DialectSQLServer.jdbcInfo("NVARCHAR(MAX)", 2005);
                }
                return DialectSQLServer.jdbcInfo("NVARCHAR(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectSQLServer.jdbcInfo("BIT", -7);
            }
            case LONG: {
                return DialectSQLServer.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return DialectSQLServer.jdbcInfo("DOUBLE PRECISION", 8);
            }
            case TIMESTAMP: {
                return DialectSQLServer.jdbcInfo("DATETIME2(3)", 93);
            }
            case BLOBID: {
                return DialectSQLServer.jdbcInfo("NVARCHAR(250)", 12);
            }
            case BLOB: {
                return DialectSQLServer.jdbcInfo("VARBINARY(MAX)", -3);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                switch (this.idType) {
                    case VARCHAR: {
                        return DialectSQLServer.jdbcInfo("NVARCHAR(36)", 12);
                    }
                    case SEQUENCE: {
                        return DialectSQLServer.jdbcInfo("BIGINT", -5);
                    }
                }
                throw new AssertionError((Object)("Unknown id type: " + this.idType));
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectSQLServer.jdbcInfo("NVARCHAR(256)", 12);
            }
            case TINYINT: {
                return DialectSQLServer.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return DialectSQLServer.jdbcInfo("INT", 4);
            }
            case AUTOINC: {
                return DialectSQLServer.jdbcInfo("INT IDENTITY", 4);
            }
            case FTINDEXED: {
                throw new AssertionError(type);
            }
            case FTSTORED: {
                return DialectSQLServer.jdbcInfo("NVARCHAR(MAX)", 2005);
            }
            case CLUSTERNODE: {
                return DialectSQLServer.jdbcInfo("SMALLINT", 5);
            }
            case CLUSTERFRAGS: {
                return DialectSQLServer.jdbcInfo("NVARCHAR(4000)", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 12 && actual == -9) {
            return true;
        }
        if (expected == 12 && actual == -16) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == 2005 && actual == -9) {
            return true;
        }
        if (expected == 2005 && actual == -16) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setId(PreparedStatement ps, int index, Serializable value) throws SQLException {
        switch (this.idType) {
            case VARCHAR: {
                ps.setObject(index, (Object)value, 12);
                break;
            }
            case SEQUENCE: {
                this.setIdLong(ps, index, value);
            }
        }
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                ps.setLong(index, ((Number)value).longValue());
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
            case -3: {
                ps.setBytes(index, (byte[])value);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                return this.getFromResultSetString(rs, index, column);
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
            case -3: {
                return rs.getBytes(index);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    protected int getMaxNameSize() {
        return 128;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public boolean supportsMultipleFulltextIndexes() {
        return false;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CREATE FULLTEXT INDEX ON %s (", table.getQuotedName()));
        Iterator<Column> it = columns.iterator();
        while (it.hasNext()) {
            sb.append(String.format("%s LANGUAGE %s", it.next().getQuotedName(), this.getQuotedFulltextAnalyzer()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        String fulltextUniqueIndex = "[fulltext_pk]";
        sb.append(String.format(") KEY INDEX %s ON [%s]", fulltextUniqueIndex, this.fulltextCatalog));
        return sb.toString();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        FulltextQueryAnalyzer.FulltextQuery ft = FulltextQueryAnalyzer.analyzeFulltextQuery((String)(query = query.replace("%", "*")));
        if (ft == null) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        return FulltextQueryAnalyzer.translateFulltext((FulltextQueryAnalyzer.FulltextQuery)ft, (String)"OR", (String)"AND", (String)"AND NOT", (String)"\"", (String)"\"", Collections.emptySet(), (String)"\"", (String)"\"", (boolean)false);
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        String tableAlias = "_nxfttbl" + nthSuffix;
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        info.joins = new ArrayList<Join>();
        if (nthMatch == 1) {
            info.joins.add(new Join(2, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.joins.add(new Join(2, String.format("CONTAINSTABLE(%s, *, ?, LANGUAGE %s)", ft.getQuotedName(), this.getQuotedFulltextAnalyzer()), tableAlias, fulltextQuery, ftMain.getFullQuotedName(), String.format("%s.[KEY]", tableAlias)));
        info.whereExpr = String.format("%s.[KEY] IS NOT NULL", tableAlias);
        info.scoreExpr = String.format("(%s.RANK / 1000.0)", tableAlias);
        info.scoreAlias = "_nxscore" + nthSuffix;
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    protected String getQuotedFulltextAnalyzer() {
        if (!Character.isDigit(this.fulltextAnalyzer.charAt(0))) {
            return String.format("'%s'", this.fulltextAnalyzer);
        }
        return this.fulltextAnalyzer;
    }

    @Override
    public String getLikeEscaping() {
        return " ESCAPE '\\'";
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public boolean needsOriginalColumnInGroupBy() {
        return true;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("dbo.NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public boolean supportsFastDescendants() {
        return this.pathOptimizationsEnabled;
    }

    @Override
    public String getInTreeSql(String idColumnName, String id) {
        String idParam;
        switch (this.idType) {
            case VARCHAR: {
                idParam = "?";
                break;
            }
            case SEQUENCE: {
                if (id != null && !StringUtils.isNumeric((CharSequence)id)) {
                    return null;
                }
                idParam = "CONVERT(BIGINT, ?)";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown id type: " + this.idType));
            }
        }
        if (this.pathOptimizationsEnabled) {
            return String.format("EXISTS(SELECT 1 FROM ancestors WHERE hierarchy_id = %s AND ancestor = %s)", idColumnName, idParam);
        }
        return String.format("%s IN (SELECT * FROM dbo.nx_children(%s))", idColumnName, idParam);
    }

    @Override
    public String getUpsertSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues) {
        return this.getMergeSql(columns, values, outColumns, outValues, true);
    }

    @Override
    public String getInsertOnConflictDoNothingSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues) {
        return this.getMergeSql(columns, values, outColumns, outValues, false);
    }

    protected String getMergeSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues, boolean updateWhenMatched) {
        int i;
        Column keyColumn = columns.get(0);
        Table table = keyColumn.getTable();
        StringBuilder sql = new StringBuilder();
        sql.append("MERGE ");
        sql.append(table.getQuotedName());
        sql.append(" USING (VALUES(");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
            outColumns.add(columns.get(i));
            outValues.add(values.get(i));
        }
        sql.append(")) AS source (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append(columns.get(i).getQuotedName());
        }
        sql.append(") ON ");
        sql.append(table.getQuotedName());
        sql.append(".");
        sql.append(keyColumn.getQuotedName());
        sql.append(" = source.");
        sql.append(keyColumn.getQuotedName());
        if (updateWhenMatched) {
            sql.append(" WHEN MATCHED THEN UPDATE SET ");
            for (i = 1; i < columns.size(); ++i) {
                if (i != 1) {
                    sql.append(", ");
                }
                sql.append(columns.get(i).getQuotedName());
                sql.append(" = ?");
                outColumns.add(columns.get(i));
                outValues.add(values.get(i));
            }
        }
        sql.append(" WHEN NOT MATCHED THEN INSERT (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append(columns.get(i).getQuotedName());
        }
        sql.append(") VALUES (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
            outColumns.add(columns.get(i));
            outValues.add(values.get(i));
        }
        sql.append(")");
        sql.append(";");
        return sql.toString();
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/sqlserver.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/sqlserver.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        switch (this.idType) {
            case VARCHAR: {
                properties.put("idType", (Serializable)((Object)"NVARCHAR(36)"));
                properties.put("idTypeParam", (Serializable)((Object)"NVARCHAR"));
                properties.put("idNotPresent", (Serializable)((Object)"'-'"));
                properties.put("sequenceEnabled", Boolean.FALSE);
                break;
            }
            case SEQUENCE: {
                properties.put("idType", (Serializable)((Object)"BIGINT"));
                properties.put("idTypeParam", (Serializable)((Object)"BIGINT"));
                properties.put("idNotPresent", (Serializable)((Object)"-1"));
                properties.put("sequenceEnabled", Boolean.TRUE);
                properties.put("idSequenceName", (Serializable)((Object)this.idSequenceName));
            }
        }
        properties.put("lockEscalationDisabled", Boolean.valueOf(this.supportsLockEscalationDisable()));
        properties.put("md5HashString", (Serializable)((Object)this.getMd5HashString()));
        String readAclMaxSizeStr = this.readAclMaxSize <= 0 ? "4000" : (this.readAclMaxSize > 4000 ? "MAX" : Integer.toString(this.readAclMaxSize));
        properties.put("readAclMaxSize", (Serializable)((Object)readAclMaxSizeStr));
        properties.put("reseedAclrModified", (Serializable)((Object)(this.azure ? "" : "DBCC CHECKIDENT('aclr_modified', RESEED, 0);")));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("fulltextSearchEnabled", Boolean.valueOf(!this.fulltextSearchDisabled));
        properties.put("fulltextCatalog", (Serializable)((Object)this.fulltextCatalog));
        properties.put("aclOptimizationsEnabled", Boolean.valueOf(this.aclOptimizationsEnabled));
        properties.put("pathOptimizationsEnabled", Boolean.valueOf(this.pathOptimizationsEnabled));
        properties.put("clusteringEnabled", Boolean.valueOf(this.clusteringEnabled));
        properties.put("proxiesEnabled", Boolean.valueOf(this.proxiesEnabled));
        properties.put("softDeleteEnabled", Boolean.valueOf(this.softDeleteEnabled));
        properties.put("disableVersionACL", Boolean.valueOf(this.disableVersionACL));
        properties.put("disableReadVersionPermission", Boolean.valueOf(this.disableReadVersionPermission));
        String[] permissions = ((SecurityService)Framework.getService(SecurityService.class)).getPermissionsToCheck("Browse");
        LinkedList<String> permsList = new LinkedList<String>();
        for (String perm : permissions) {
            permsList.add(String.format("  SELECT '%s' ", perm));
        }
        properties.put("readPermissions", (Serializable)((Object)String.join((CharSequence)" UNION ALL ", permsList)));
        properties.put("usersSeparator", (Serializable)((Object)this.getUsersSeparator()));
        return properties;
    }

    protected String getMd5HashString() {
        if (this.majorVersion <= 9) {
            return "SUBSTRING(master.dbo.fn_varbintohexstr(HashBytes('MD5', @string)), 3, 32)";
        }
        return "SUBSTRING(CONVERT(VARCHAR(34), HashBytes('MD5', @string), 1), 3, 32)";
    }

    protected boolean supportsLockEscalationDisable() {
        return this.majorVersion > 9;
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getPrepareUserReadAclsSql() {
        return "EXEC nx_prepare_user_read_acls ?";
    }

    @Override
    public String getReadAclsCheckSql(String userIdCol) {
        return String.format("%s = dbo.nx_md5(?)", userIdCol);
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "EXEC dbo.nx_update_read_acls";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "EXEC dbo.nx_rebuild_read_acls";
    }

    @Override
    public List<String> getStartupSqls(Model model, Database database) {
        if (this.aclOptimizationsEnabled) {
            log.info((Object)"Vacuuming tables used by optimized acls");
            return Collections.singletonList("EXEC nx_vacuum_read_acls");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "EXEC dbo.NX_CLUSTER_INVAL ?, ?, ?, ?";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "SELECT [id], [fragments], [kind] FROM [cluster_invals] WHERE [nodeid] = ?";
    }

    @Override
    public boolean isConcurrentUpdateException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SQLException) {
            switch (((SQLException)t).getErrorCode()) {
                case 547: 
                case 1205: 
                case 2627: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getBlobLengthFunction() {
        return "DATALENGTH";
    }

    public String getUsersSeparator() {
        if (this.usersSeparator == null) {
            return DEFAULT_USERS_SEPARATOR;
        }
        return this.usersSeparator;
    }

    @Override
    public Serializable getGeneratedId(Connection connection) throws SQLException {
        if (this.idType != Dialect.DialectIdType.SEQUENCE) {
            return super.getGeneratedId(connection);
        }
        String sql = String.format("SELECT NEXT VALUE FOR [%s]", this.idSequenceName);
        try (Statement s = connection.createStatement();){
            Long l;
            block13: {
                ResultSet rs = s.executeQuery(sql);
                try {
                    rs.next();
                    l = rs.getLong(1);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
    }

    @Override
    public void performPostOpenStatements(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("SET TRANSACTION ISOLATION LEVEL READ COMMITTED");
        }
    }

    @Override
    public String getAncestorsIdsSql() {
        return "SELECT id FROM dbo.NX_ANCESTORS(?)";
    }

    @Override
    public String getDateCast() {
        if (this.majorVersion <= 9) {
            return "CONVERT(DATETIME, CONVERT(VARCHAR, %s, 112), 112)";
        }
        return super.getDateCast();
    }

    @Override
    public String castIdToVarchar(String expr) {
        switch (this.idType) {
            case VARCHAR: {
                return expr;
            }
            case SEQUENCE: {
                return "CONVERT(VARCHAR, " + expr + ")";
            }
        }
        throw new AssertionError((Object)("Unknown id type: " + this.idType));
    }

    @Override
    public Dialect.DialectIdType getIdType() {
        return this.idType;
    }

    @Override
    public List<String> getIgnoredColumns(Table table) {
        return Collections.singletonList(CLUSTER_INDEX_COL);
    }

    protected boolean needsClusteredColumn(Table table) {
        if (this.idType == Dialect.DialectIdType.SEQUENCE) {
            return false;
        }
        for (Column col : table.getColumns()) {
            if (!col.getType().isId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCustomColumnDefinition(Table table) {
        if (!this.needsClusteredColumn(table)) {
            return null;
        }
        return String.format("[%s] BIGINT NOT NULL IDENTITY", CLUSTER_INDEX_COL);
    }

    @Override
    public List<String> getCustomPostCreateSqls(Table table, Model model) {
        if (!this.needsClusteredColumn(table)) {
            return Collections.emptyList();
        }
        String quotedIndexName = this.getIndexName(table.getKey(), Collections.singletonList(CLUSTER_INDEX_COL));
        String sql = String.format("CREATE UNIQUE CLUSTERED INDEX [%s] ON %s ([%s])", quotedIndexName, table.getQuotedName(), CLUSTER_INDEX_COL);
        return Collections.singletonList(sql);
    }

    @Override
    public String getSoftDeleteSql() {
        return "EXEC dbo.NX_DELETE ?, ?";
    }

    @Override
    public String getSoftDeleteCleanupSql() {
        return "{?= call dbo.NX_DELETE_PURGE(?, ?)}";
    }

    @Override
    public List<String> checkStoredProcedure(String procName, String procCreate, String ddlMode, Connection connection, JDBCLogger logger, Map<String, Serializable> properties) throws SQLException {
        boolean compatCheck = ddlMode.contains("compat");
        String procCreateLower = procCreate.toLowerCase();
        String procDrop = procCreateLower.startsWith("create function ") ? "DROP FUNCTION " + procName : (procCreateLower.startsWith("create procedure ") ? "DROP PROCEDURE " + procName : "DROP TRIGGER " + procName);
        if (compatCheck) {
            procDrop = "IF OBJECT_ID('" + procName + "') IS NOT NULL " + procDrop;
            return Arrays.asList(procDrop, procCreate);
        }
        try (Statement st = connection.createStatement();){
            List<String> list;
            block21: {
                ResultSet rs;
                block19: {
                    List<String> list2;
                    block20: {
                        String body;
                        block17: {
                            List<String> list3;
                            block18: {
                                String getBody = "SELECT OBJECT_DEFINITION(OBJECT_ID('" + procName + "'))";
                                logger.log(getBody);
                                rs = st.executeQuery(getBody);
                                try {
                                    rs.next();
                                    body = rs.getString(1);
                                    if (body != null) break block17;
                                    logger.log("  -> missing");
                                    list3 = Collections.singletonList(procCreate);
                                    if (rs == null) break block18;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return list3;
                        }
                        if (!DialectSQLServer.normalizeString(procCreate).contains(DialectSQLServer.normalizeString(body))) break block19;
                        logger.log("  -> exists, unchanged");
                        list2 = Collections.emptyList();
                        if (rs == null) break block20;
                        rs.close();
                    }
                    return list2;
                }
                logger.log("  -> exists, old");
                list = Arrays.asList(procDrop, procCreate);
                if (rs == null) break block21;
                rs.close();
            }
            return list;
        }
    }

    protected static String normalizeString(String string) {
        return string.replaceAll("[ \n\r\t]+", " ").trim();
    }

    @Override
    public String getSQLForDump(String sql) {
        return sql + "\nGO";
    }
}

