/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileNamePattern;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.application.FileWalker;

public class BundleWalker
extends FileWalker.Visitor {
    private static final Log log = LogFactory.getLog(BundleWalker.class);
    public static final FileNamePattern[] DEFAULT_PATTERNS = new FileNamePattern[]{new FileNamePattern("*.jar"), new FileNamePattern("*.war"), new FileNamePattern("*.rar"), new FileNamePattern("*.sar"), new FileNamePattern("*_jar"), new FileNamePattern("*_war"), new FileNamePattern("*_rar")};
    private FileNamePattern[] patterns;
    private final Callback callback;

    public BundleWalker(Callback cb) {
        this(cb, DEFAULT_PATTERNS);
    }

    public BundleWalker(Callback cb, String[] patterns) {
        if (patterns != null) {
            this.patterns = new FileNamePattern[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                this.patterns[i] = new FileNamePattern(patterns[i]);
            }
        }
        this.callback = cb;
    }

    public BundleWalker(Callback cb, FileNamePattern[] patterns) {
        this.patterns = patterns;
        this.callback = cb;
    }

    public void visit(File root) {
        FileWalker.walk(root, this);
    }

    public void visit(Collection<File> files) {
        for (File file : files) {
            if (!file.isFile()) continue;
            if (file.isFile()) {
                this.visitFile(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.visitDirectory(file);
        }
    }

    public void visit(File ... files) {
        for (File file : files) {
            if (!file.isFile()) continue;
            if (file.isFile()) {
                this.visitFile(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.visitDirectory(file);
        }
    }

    @Override
    public int visitDirectory(File file) {
        String fileName = file.getName();
        if (this.patterns != null && !this.acceptFile(fileName, this.patterns)) {
            return 0;
        }
        try {
            Manifest mf = JarUtils.getDirectoryManifest((File)file);
            if (mf == null) {
                return 0;
            }
            String bundleName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
            if (bundleName != null) {
                this.callback.visitBundle(new DirectoryBundleFile(file, mf));
                return 2;
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int visitFile(File file) {
        String fileName = file.getName();
        if (this.patterns != null && !this.acceptFile(fileName, this.patterns)) {
            return 0;
        }
        try (JarFile jarFile = new JarFile(file);){
            if (jarFile.getManifest() == null) {
                int n = 0;
                return n;
            }
            JarBundleFile bundleFile = new JarBundleFile(jarFile);
            if (bundleFile.getSymbolicName() != null) {
                this.callback.visitBundle(bundleFile);
                return 0;
            }
            this.callback.visitJar(bundleFile);
            return 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    protected boolean acceptFile(String fileName, FileNamePattern[] patterns) {
        int i;
        for (i = 0; i < patterns.length && !patterns[i].match(fileName); ++i) {
        }
        return i < patterns.length;
    }

    public static interface Callback {
        public void visitBundle(BundleFile var1) throws IOException;

        public void visitJar(BundleFile var1) throws IOException;
    }
}

