/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.install.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.runtime.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;

public class MkfileCommand
implements Command {
    protected final Path path;
    protected final byte[] content;

    public MkfileCommand(Path path, byte[] content) {
        this.path = path;
        this.content = content;
    }

    @Override
    public void exec(CommandContext ctx) throws IOException {
        File baseDir = ctx.getBaseDir();
        File file = new File(baseDir, ctx.expandVars(this.path.toString()));
        File parent = file.getParentFile();
        if (!parent.isDirectory()) {
            parent.mkdirs();
        }
        if (this.content != null && this.content.length > 0) {
            FileUtils.writeByteArrayToFile((File)file, (byte[])this.content);
        } else {
            Files.createFile(file.toPath(), new FileAttribute[0]);
        }
    }

    public String toString() {
        return "mkfile " + this.path.toString();
    }

    @Override
    public String toString(CommandContext ctx) {
        return "mkfile " + ctx.expandVars(this.path.toString());
    }
}

