/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;

public interface WorkQueuing {
    public NuxeoBlockingQueue init(WorkQueueDescriptor var1);

    public void setActive(String var1, boolean var2);

    public boolean supportsProcessingDisabling();

    public NuxeoBlockingQueue getQueue(String var1);

    public void workSchedule(String var1, Work var2);

    public void workCanceled(String var1, Work var2);

    public void workRunning(String var1, Work var2);

    public void workCompleted(String var1, Work var2);

    public void workReschedule(String var1, Work var2);

    public Work find(String var1, Work.State var2);

    public void removeScheduled(String var1, String var2);

    public boolean isWorkInState(String var1, Work.State var2);

    public Work.State getWorkState(String var1);

    public List<Work> listWork(String var1, Work.State var2);

    public List<String> listWorkIds(String var1, Work.State var2);

    public long count(String var1, Work.State var2);

    public WorkQueueMetrics metrics(String var1);

    public void listen(Listener var1);

    public static interface Listener {
        public void queueActivated(WorkQueueMetrics var1);

        public void queueDeactivated(WorkQueueMetrics var1);

        public void queueChanged(Work var1, WorkQueueMetrics var2);

        public static Listener lookupListener() {
            Log log = LogFactory.getLog(WorkQueuing.class);
            if (log.isTraceEnabled()) {
                class Tracing
                implements Listener {
                    private final Log log;

                    protected Tracing(Log log) {
                        this.log = log;
                    }

                    @Override
                    public void queueChanged(Work work, WorkQueueMetrics metrics) {
                        this.log.trace((Object)String.format("%s -> changed on %s %s", new Object[]{metrics, work.getWorkInstanceState(), work.getSchedulePath()}));
                    }

                    @Override
                    public void queueActivated(WorkQueueMetrics metrics) {
                        this.log.trace((Object)String.format("%s -> activated", metrics));
                    }

                    @Override
                    public void queueDeactivated(WorkQueueMetrics metrics) {
                        this.log.trace((Object)String.format("%s -> deactivated", metrics));
                    }
                }
                return new Tracing(log);
            }
            class Null
            implements Listener {
                Null() {
                }

                @Override
                public void queueActivated(WorkQueueMetrics metric) {
                }

                @Override
                public void queueDeactivated(WorkQueueMetrics metric) {
                }

                @Override
                public void queueChanged(Work work, WorkQueueMetrics metric) {
                }
            }
            return new Null();
        }
    }
}

