/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.servlet;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import io.opencensus.common.Scope;
import io.opencensus.contrib.http.HttpRequestContext;
import io.opencensus.contrib.http.HttpServerHandler;
import io.opencensus.contrib.http.servlet.OcHttpServletListener;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OcHttpServletUtil {
    static final String CONTENT_LENGTH = "Content-Length";
    static final String OPENCENSUS_SERVLET_LISTENER = "opencensus.servlet.listener";

    private OcHttpServletUtil() {
    }

    static void recordMessageSentEvent(HttpServerHandler<HttpServletRequest, HttpServletResponse, HttpServletRequest> handler, HttpRequestContext context, HttpServletResponse response) {
        String length;
        if (response != null && (length = response.getHeader(CONTENT_LENGTH)) != null && !length.isEmpty()) {
            try {
                handler.handleMessageSent(context, (long)Integer.parseInt(length));
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }

    @MustBeClosed
    public static Scope withScope(ServletRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        OcHttpServletListener listener = (OcHttpServletListener)request.getAttribute(OPENCENSUS_SERVLET_LISTENER);
        if (listener != null) {
            return listener.withSpan();
        }
        return Tracing.getTracer().withSpan((Span)BlankSpan.INSTANCE);
    }
}

