/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.util.List;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.restapi.server.jaxrs.RepositoryObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="apiObject")
public class APIObject
extends DefaultObject {
    @Path(value="/")
    public Object doGetRepository() {
        return this.doGetRepository(null);
    }

    @Path(value="/repo/{repositoryName}")
    public Object doGetRepository(@PathParam(value="repositoryName") String repositoryName) {
        if (StringUtils.isNotBlank((CharSequence)repositoryName)) {
            try {
                this.ctx.setRepositoryName(repositoryName);
            }
            catch (IllegalArgumentException e) {
                throw new WebResourceNotFoundException(e.getMessage());
            }
        }
        return this.newObject("repo", new Object[0]);
    }

    @Path(value="/user")
    public Object doGetUser() {
        return this.newObject("users", new Object[0]);
    }

    @Path(value="/group")
    public Object doGetGroup() {
        return this.newObject("groups", new Object[0]);
    }

    @Path(value="/automation")
    public Object getAutomationEndPoint() {
        return this.newObject("automation", new Object[0]);
    }

    @Path(value="/directory")
    public Object doGetDirectory() {
        return this.newObject("directory", new Object[0]);
    }

    @Path(value="/doc")
    public Object doGetDocumentation() {
        return this.newObject("doc", new Object[0]);
    }

    @Path(value="/query")
    public Object doQuery() {
        return this.newObject("query", new Object[0]);
    }

    @Path(value="/config")
    public Object doGetConfig() {
        return this.newObject("config", new Object[0]);
    }

    @Path(value="/conversion")
    public Object doGetConversion() {
        return this.newObject("conversions", new Object[0]);
    }

    @Path(value="/bulk")
    public Object bulk(@MatrixParam(value="id") List<String> ids) {
        if (ids.isEmpty()) {
            return this.newObject("bulkActionFramework", new Object[0]);
        }
        return RepositoryObject.getBulkDocuments(this, ids);
    }

    @Path(value="/server")
    public Object server() {
        return this.newObject("server", new Object[0]);
    }

    @Path(value="/ext/{otherPath}")
    public Object route(@PathParam(value="otherPath") String otherPath) {
        return this.newObject(otherPath, new Object[0]);
    }
}

