/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.directory;

import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryDeleteConstraint;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.restapi.server.jaxrs.directory.DirectoryObject;
import org.nuxeo.ecm.restapi.server.jaxrs.directory.DirectorySessionRunner;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="directoryEntry")
public class DirectoryEntryObject
extends DefaultObject {
    protected DirectoryEntry entry;
    protected Directory directory;
    protected String entryId;

    protected void initialize(Object ... args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Directory Entry object takes one parameter");
        }
        this.entry = (DirectoryEntry)args[0];
        this.directory = this.getDirectoryFromEntry(this.entry);
        this.entryId = (String)args[1];
    }

    @GET
    public DirectoryEntry doGet() {
        return this.entry;
    }

    @PUT
    public DirectoryEntry doUpdateEntry(final DirectoryEntry entry) {
        this.checkEditGuards();
        return DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<DirectoryEntry>(){

            @Override
            DirectoryEntry run(Session session) {
                try {
                    DocumentModel docEntry = entry.getDocumentModel();
                    session.updateEntry(docEntry);
                    return new DirectoryEntry(DirectoryEntryObject.this.directory.getName(), session.getEntry(docEntry.getId()));
                }
                catch (DirectoryException e) {
                    throw new NuxeoException(e.getMessage(), 400);
                }
            }
        });
    }

    private void checkEditGuards() {
        ((DirectoryObject)this.prev).checkEditGuards();
    }

    private void checkDeleteGuards() {
        List deleteConstraints = this.directory.getDirectoryDeleteConstraints();
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        if (deleteConstraints != null && !deleteConstraints.isEmpty()) {
            for (DirectoryDeleteConstraint deleteConstraint : deleteConstraints) {
                if (deleteConstraint.canDelete(directoryService, this.entryId)) continue;
                throw new NuxeoException("This entry is referenced in another vocabulary.", 409);
            }
        }
    }

    @DELETE
    public Response doDeleteEntry() {
        this.checkEditGuards();
        this.checkDeleteGuards();
        DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<DirectoryEntry>(){

            @Override
            DirectoryEntry run(Session session) {
                session.deleteEntry(DirectoryEntryObject.this.entry.getDocumentModel());
                return null;
            }
        });
        return Response.ok().status(Response.Status.NO_CONTENT).build();
    }

    private Directory getDirectoryFromEntry(DirectoryEntry entry) {
        Directory directory;
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try {
            directory = ds.getDirectory(entry.getDirectoryName());
        }
        catch (DirectoryException e) {
            throw new WebResourceNotFoundException("directory not found");
        }
        return directory;
    }
}

