/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.joda.time.DateTimeZone;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketRangeDate;
import org.nuxeo.elasticsearch.aggregate.DateHelper;
import org.nuxeo.elasticsearch.aggregate.MultiBucketAggregate;

public class DateHistogramAggregate
extends MultiBucketAggregate<BucketRangeDate> {
    public DateHistogramAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public DateHistogramAggregationBuilder getEsAggregate() {
        DateHistogramAggregationBuilder ret = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)this.getId()).field(this.getField())).timeZone(DateTimeZone.getDefault().toTimeZone().toZoneId());
        Map props = this.getProperties();
        if (props.containsKey("interval")) {
            ret.dateHistogramInterval(new DateHistogramInterval((String)props.get("interval")));
        }
        if (props.containsKey("minDocCount")) {
            ret.minDocCount(Long.parseLong((String)props.get("minDocCount")));
        }
        if (props.containsKey("order")) {
            switch (((String)props.get("order")).toLowerCase()) {
                case "count desc": {
                    ret.order(BucketOrder.count((boolean)false));
                    break;
                }
                case "count asc": {
                    ret.order(BucketOrder.count((boolean)true));
                    break;
                }
                case "key desc": {
                    ret.order(BucketOrder.key((boolean)false));
                    break;
                }
                case "key asc": {
                    ret.order(BucketOrder.key((boolean)true));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid order: " + (String)props.get("order"));
                }
            }
        }
        if (props.containsKey("extendedBoundsMax") && props.containsKey("extendedBoundsMin")) {
            ret.extendedBounds(new ExtendedBounds((String)props.get("extendedBoundsMin"), (String)props.get("extendedBoundsMax")));
        }
        if (props.containsKey("timeZone")) {
            ret.timeZone(DateTimeZone.forID((String)((String)props.get("timeZone"))).toTimeZone().toZoneId());
        }
        if (props.containsKey("preZone")) {
            ret.timeZone(DateTimeZone.forID((String)((String)props.get("preZone"))).toTimeZone().toZoneId());
        }
        if (props.containsKey("format")) {
            ret.format((String)props.get("format"));
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        BoolQueryBuilder ret = QueryBuilders.boolQuery();
        for (String sel : this.getSelection()) {
            RangeQueryBuilder rangeFilter = QueryBuilders.rangeQuery((String)this.getField());
            ZonedDateTime from = this.convertStringToDate(sel);
            ZonedDateTime to = DateHelper.plusDuration(from, this.getInterval());
            rangeFilter.gte((Object)from.toInstant().toEpochMilli()).lt((Object)to.toInstant().toEpochMilli()).format("epoch_millis");
            ret.should((QueryBuilder)rangeFilter);
        }
        return ret;
    }

    private ZonedDateTime convertStringToDate(String date) {
        Map props = this.getProperties();
        String timezone = "UTC";
        if (props.containsKey("timeZone")) {
            timezone = (String)props.get("timeZone");
        }
        if (!props.containsKey("format")) {
            throw new IllegalArgumentException("format property must be defined for " + this.toString());
        }
        DateTimeFormatter fmt = DateUtils.robustOfPattern((String)((String)props.get("format"))).withZone(ZoneId.of(timezone));
        TemporalAccessor ta = fmt.parseBest(date, ZonedDateTime::from, LocalDate::from);
        if (ta instanceof LocalDate) {
            return ((LocalDate)ta).atStartOfDay(ZoneId.of(timezone));
        }
        return (ZonedDateTime)ta;
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketRangeDate> nxBuckets = new ArrayList<BucketRangeDate>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            ZonedDateTime fromZDT = (ZonedDateTime)bucket.getKey();
            ZonedDateTime toZDT = DateHelper.plusDuration(fromZDT, this.getInterval());
            nxBuckets.add(new BucketRangeDate(bucket.getKeyAsString(), fromZDT, toZDT, bucket.getDocCount()));
        }
        this.buckets = nxBuckets;
    }

    private String getInterval() {
        Map props = this.getProperties();
        if (!props.containsKey("interval")) {
            throw new IllegalArgumentException("interval property must be defined for " + this.toString());
        }
        String ret = (String)props.get("interval");
        return ret;
    }
}

