/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.elasticsearch.action.search.SearchResponse;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.elasticsearch.core.EsSearchHitConverter;

public class EsResultSetImpl
implements IterableQueryResult,
Iterator<Map<String, Serializable>> {
    private final SearchResponse response;
    private final Map<String, Type> selectFieldsAndTypes;
    protected List<Map<String, Serializable>> maps;
    protected long size;
    boolean closed;
    private long pos;

    public EsResultSetImpl(SearchResponse response, Map<String, Type> selectFieldsAndTypes) {
        this.response = response;
        this.selectFieldsAndTypes = selectFieldsAndTypes;
        this.maps = this.buildMaps();
        this.size = this.maps.size();
    }

    protected List<Map<String, Serializable>> buildMaps() {
        return new EsSearchHitConverter(this.selectFieldsAndTypes).convert(this.response.getHits().getHits());
    }

    public void close() {
        this.closed = true;
        this.pos = -1L;
    }

    public boolean isLife() {
        return !this.closed;
    }

    public boolean mustBeClosed() {
        return false;
    }

    public long size() {
        return this.size;
    }

    public long totalSize() {
        return this.response.getHits().getTotalHits().value;
    }

    public long pos() {
        return this.pos;
    }

    public void skipTo(long pos) {
        if (pos < 0L) {
            pos = 0L;
        } else if (pos > this.size) {
            pos = this.size;
        }
        this.pos = pos;
    }

    public Iterator<Map<String, Serializable>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.size;
    }

    @Override
    public Map<String, Serializable> next() {
        if (this.closed || this.pos == this.size) {
            throw new NoSuchElementException();
        }
        Map<String, Serializable> map = this.maps.get((int)this.pos);
        ++this.pos;
        return map;
    }
}

