/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.search.SearchHit;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;

public class EsSearchHitConverter {
    private final Map<String, Type> selectFieldsAndTypes;
    private final Map<String, Serializable> emptyRow;

    public EsSearchHitConverter(Map<String, Type> selectFieldsAndTypes) {
        this.selectFieldsAndTypes = selectFieldsAndTypes;
        this.emptyRow = EsSearchHitConverter.buildEmptyRow(selectFieldsAndTypes);
    }

    private static Map<String, Serializable> buildEmptyRow(Map<String, Type> selectFieldsAndTypes) {
        HashMap<String, Serializable> emptyRow = new HashMap<String, Serializable>(selectFieldsAndTypes.size());
        for (String fieldName : selectFieldsAndTypes.keySet()) {
            emptyRow.put(fieldName, null);
        }
        return emptyRow;
    }

    public List<Map<String, Serializable>> convert(SearchHit ... hits) {
        return Arrays.stream(hits).map(this::convert).collect(Collectors.toList());
    }

    public Map<String, Serializable> convert(SearchHit hit) {
        HashMap<String, Serializable> row = new HashMap<String, Serializable>(this.emptyRow);
        hit.getSourceAsMap().forEach((name, value) -> {
            Type type;
            if (value instanceof String && (type = this.selectFieldsAndTypes.get(name)) instanceof DateType) {
                value = type.decode((String)value);
            }
            row.put((String)name, (Serializable)value);
        });
        if (this.selectFieldsAndTypes.containsKey("ecm:fulltextScore")) {
            row.put("ecm:fulltextScore", Double.valueOf(hit.getScore()));
        }
        return row;
    }
}

