/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.Bundle;

public class RedisComponent
extends DefaultComponent
implements RedisAdmin {
    public static final String XP_CONFIG = "configuration";
    private static final String DEFAULT_PREFIX = "nuxeo:";
    protected volatile RedisExecutor executor;
    protected String delsha;

    @Override
    public RedisPoolDescriptor getConfig() {
        return (RedisPoolDescriptor)this.getDescriptor(XP_CONFIG, "");
    }

    public void start(ComponentContext context) {
        super.start(context);
        RedisPoolDescriptor config = this.getConfig();
        if (config == null || config.disabled) {
            return;
        }
        this.executor = config.newExecutor();
        try {
            this.delsha = this.load("org.nuxeo.runtime.redis", "del-keys");
        }
        catch (RuntimeException cause) {
            this.executor = null;
            throw new RuntimeException("Cannot activate redis executor", cause);
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        if (this.executor == null) {
            return;
        }
        try {
            this.executor.getPool().close();
        }
        finally {
            this.executor = null;
        }
    }

    public int getApplicationStartedOrder() {
        ComponentInstance compo = Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.core.work.service");
        return compo != null ? ((DefaultComponent)compo.getInstance()).getApplicationStartedOrder() - 1 : -500;
    }

    @Override
    public Long clear(String pattern) {
        return (Long)this.executor.evalsha(this.delsha, Collections.singletonList(pattern), Collections.emptyList());
    }

    @Override
    public String load(String bundleName, String scriptName) {
        StringBuilder builder;
        Bundle b = Framework.getRuntime().getBundle(bundleName);
        URL loc = b.getEntry(scriptName + ".lua");
        if (loc == null) {
            throw new RuntimeException("Fail to load lua script: " + scriptName);
        }
        try (InputStream is = loc.openStream();){
            builder = new StringBuilder();
            for (String line : IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8)) {
                builder.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to load lua script: " + scriptName, e);
        }
        return this.executor.scriptLoad(builder.toString());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(RedisExecutor.class)) {
            return adapter.cast(this.executor);
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public String namespace(String ... names) {
        String prefix;
        RedisPoolDescriptor config = this.getConfig();
        String string = prefix = config == null ? null : config.prefix;
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = DEFAULT_PREFIX;
        }
        StringBuilder builder = new StringBuilder(prefix);
        for (String name : names) {
            builder.append(name).append(":");
        }
        return builder.toString();
    }
}

