/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import java.util.List;
import org.nuxeo.lib.stream.log.LogConfig;
import org.nuxeo.lib.stream.log.Name;

public abstract class AbstractLogConfig
implements LogConfig {
    protected final List<String> patterns;
    protected final boolean defaultConfig;

    public AbstractLogConfig(boolean defaultConfig, List<String> patterns) {
        this.defaultConfig = defaultConfig;
        if (patterns == null) {
            throw new IllegalArgumentException("patterns required");
        }
        this.patterns = patterns;
    }

    @Override
    public boolean isDefault() {
        return this.defaultConfig;
    }

    @Override
    public boolean match(Name name) {
        return this.patterns.stream().anyMatch(pattern -> name.getUrn().startsWith((String)pattern));
    }

    @Override
    public boolean match(Name name, Name group) {
        if (this.patterns.stream().anyMatch(pattern -> group.getUrn().startsWith((String)pattern))) {
            return true;
        }
        return this.match(name);
    }
}

