/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import org.nuxeo.lib.stream.log.Name;

public class LogPartition {
    protected final Name name;
    protected final int partition;

    public LogPartition(Name name, int partition) {
        this.name = name;
        this.partition = partition;
    }

    public static LogPartition of(Name name, int partition) {
        return new LogPartition(name, partition);
    }

    public Name name() {
        return this.name;
    }

    public int partition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogPartition that = (LogPartition)o;
        return this.partition == that.partition && (this.name != null ? this.name.equals(that.name) : that.name == null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.partition;
        return result;
    }

    public String toString() {
        return String.format("%s-%02d", this.name.getId(), this.partition);
    }
}

