/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.tools.command.Command;

public class AppendCommand
extends Command {
    private static final Log log = LogFactory.getLog(AppendCommand.class);
    protected static final String NAME = "append";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder().longOpt("input").desc("Avro file to append to a stream").hasArg().required().argName("INPUT").build());
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder((String)"p").longOpt("partition").desc("Write to this partition").required().hasArg().argName("PARTITION").build());
        options.addOption(Option.builder().longOpt("codec").desc("Codec used to write the records, can be: java, avro, avroBinary, avroJson").required().hasArg().argName("CODEC").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) {
        Name name = Name.ofUrn(cmd.getOptionValue("log-name"));
        String codec = cmd.getOptionValue("codec");
        int partition = Integer.parseInt(cmd.getOptionValue("partition"));
        String input = cmd.getOptionValue("input");
        this.append(manager, name, partition, codec, Paths.get(input, new String[0]));
        return true;
    }

    protected void append(LogManager manager, Name name, int partition, String codec, Path input) {
        log.info((Object)String.format("Append records from %s to stream: %s, partition: %d", input, name, partition));
        Schema schema = ReflectData.get().getSchema(Record.class);
        ReflectDatumReader datumReader = new ReflectDatumReader(schema);
        LogAppender<Record> appender = manager.getAppender(name, this.getRecordCodec(codec));
        int count = 0;
        try (DataFileReader dataFileReader = new DataFileReader(input.toFile(), (DatumReader)datumReader);){
            while (dataFileReader.hasNext()) {
                Record record = (Record)dataFileReader.next();
                appender.append(partition, record);
                ++count;
            }
        }
        catch (IOException e) {
            throw new StreamRuntimeException(e);
        }
        log.info((Object)String.format("%d record(s) appended", count));
    }
}

