/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.bulk.BulkActionValidation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractBulkActionValidation
implements BulkActionValidation {
    @Override
    public void validate(BulkCommand command) throws IllegalArgumentException {
        Set<String> params = command.getParams().keySet();
        List<String> actionParams = this.getParametersToValidate();
        for (String param : params) {
            if (actionParams.contains(param)) continue;
            throw new IllegalArgumentException(this.unknownParameterMessage(param, command));
        }
        this.validateCommand(command);
    }

    protected String invalidParameterMessage(String parameter, BulkCommand command) {
        return "Invalid " + parameter + " in command: " + command;
    }

    protected String unknownParameterMessage(String parameter, BulkCommand command) {
        return "Unknown parameter " + parameter + " in command: " + command;
    }

    protected void validateBoolean(String param, BulkCommand command) {
        Serializable value = (Serializable)command.getParam(param);
        if (value != null && !Boolean.TRUE.equals(value) && !Boolean.FALSE.equals(value)) {
            throw new IllegalArgumentException(this.invalidParameterMessage(param, command));
        }
    }

    protected void validateString(String param, BulkCommand command) {
        Serializable value = (Serializable)command.getParam(param);
        this.validateStringValue(param, value, command);
    }

    protected void validateStringValue(String param, Serializable value, BulkCommand command) {
        if (value != null && !(value instanceof String)) {
            throw new IllegalArgumentException(this.invalidParameterMessage(param, command));
        }
    }

    protected void validateMap(String param, BulkCommand command) {
        Serializable value = (Serializable)command.getParam(param);
        if (value != null && !(value instanceof Map)) {
            throw new IllegalArgumentException(this.invalidParameterMessage(param, command));
        }
    }

    protected void validateList(String param, BulkCommand command) {
        Serializable value = (Serializable)command.getParam(param);
        if (value != null && !(value instanceof List)) {
            throw new IllegalArgumentException(this.invalidParameterMessage(param, command));
        }
    }

    protected void validateSchema(String param, Serializable value, BulkCommand command) {
        this.validateStringValue(param, value, command);
        String schema = (String)((Object)value);
        if (((SchemaManager)Framework.getService(SchemaManager.class)).getSchema(schema) == null) {
            throw new IllegalArgumentException("Unknown schema " + schema + " in command: " + command);
        }
    }

    protected void validateXpath(String param, Serializable value, BulkCommand command) {
        this.validateStringValue(param, value, command);
        String xpath = (String)((Object)value);
        if (((SchemaManager)Framework.getService(SchemaManager.class)).getField(xpath) == null) {
            throw new IllegalArgumentException("Unknown xpath " + xpath + " in command: " + command);
        }
    }

    protected abstract List<String> getParametersToValidate();

    protected abstract void validateCommand(BulkCommand var1) throws IllegalArgumentException;
}

