/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.bulk.BulkActionValidation;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="action")
public class BulkActionDescriptor
implements Descriptor {
    public static final Integer DEFAULT_BUCKET_SIZE = 100;
    public static final Integer DEFAULT_BATCH_SIZE = 25;
    @XNode(value="@enabled")
    protected boolean isEnabled = true;
    @XNode(value="@name")
    public String name;
    @XNode(value="@inputStream")
    public String inputStream;
    @XNode(value="@bucketSize")
    public Integer bucketSize = DEFAULT_BUCKET_SIZE;
    @XNode(value="@batchSize")
    public Integer batchSize = DEFAULT_BATCH_SIZE;
    @XNode(value="@httpEnabled")
    public Boolean httpEnabled = Boolean.FALSE;
    @XNode(value="@sequentialCommands")
    public Boolean sequentialCommands = Boolean.FALSE;
    @XNode(value="@validationClass")
    public Class<? extends BulkActionValidation> validationClass;
    @XNode(value="@defaultScroller")
    public String defaultScroller;
    @XNode(value="@defaultQueryLimit")
    public Long defaultQueryLimit;

    public String getId() {
        return this.name;
    }

    public Integer getBucketSize() {
        return this.bucketSize;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Long getDefaultQueryLimit() {
        return this.defaultQueryLimit;
    }

    public BulkActionValidation newValidationInstance() {
        try {
            return this.validationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Cannot create validation class of type " + this.validationClass.getName(), (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public String getDefaultScroller() {
        return this.defaultScroller;
    }

    public String getInputStream() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.inputStream, (CharSequence)this.name);
    }
}

