/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.message;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.avro.reflect.AvroDefault;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.AsyncStatus;
import org.nuxeo.ecm.core.bulk.message.MapAsJsonAsStringEncoding;

public class BulkStatus
implements AsyncStatus<String> {
    private static final long serialVersionUID = 20181021L;
    protected String commandId;
    @Nullable
    protected String action;
    @Nullable
    protected String username;
    protected boolean delta;
    protected long errorCount;
    @Nullable
    protected String errorMessage;
    @Nullable
    protected Long processed;
    @Nullable
    protected State state;
    @Nullable
    protected Long submitTime;
    @Nullable
    protected Long scrollStartTime;
    @Nullable
    protected Long scrollEndTime;
    @Nullable
    protected Long processingStartTime;
    @Nullable
    protected Long processingEndTime;
    @Nullable
    protected Long completedTime;
    @Nullable
    protected Long total;
    @Nullable
    protected Long processingDurationMillis;
    @AvroDefault(value="false")
    protected boolean queryLimitReached;
    @Nullable
    @AvroEncode(using=MapAsJsonAsStringEncoding.class)
    protected Map<String, Serializable> result = new HashMap<String, Serializable>();

    protected BulkStatus() {
    }

    public BulkStatus(@NotNull String commandId) {
        this.commandId = commandId;
    }

    public static BulkStatus deltaOf(@NotNull String commandId) {
        BulkStatus ret = new BulkStatus();
        ret.setId(commandId);
        ret.delta = true;
        return ret;
    }

    public static BulkStatus unknownOf(@NotNull String commandId) {
        BulkStatus ret = new BulkStatus();
        ret.setId(commandId);
        ret.delta = true;
        ret.setState(State.UNKNOWN);
        return ret;
    }

    public void merge(@NotNull BulkStatus update) {
        if (!update.isDelta()) {
            throw new IllegalArgumentException(String.format("Cannot merge an a full status: %s with %s", this, update));
        }
        if (!this.getId().equals(update.getId())) {
            throw new IllegalArgumentException(String.format("Cannot merge different command: %s with %s", this, update));
        }
        if (update.getState() != null && this.getState() != State.ABORTED) {
            this.setState(update.getState());
        }
        if (update.processed != null) {
            this.setProcessed(this.getProcessed() + update.getProcessed());
        }
        if (update.scrollStartTime != null) {
            this.scrollStartTime = update.scrollStartTime;
        }
        if (update.scrollEndTime != null) {
            this.scrollEndTime = update.scrollEndTime;
        }
        if (update.submitTime != null) {
            this.submitTime = update.submitTime;
        }
        if (update.processingStartTime != null && (this.processingStartTime == null || update.processingStartTime < this.processingStartTime)) {
            this.processingStartTime = update.processingStartTime;
        }
        if (update.processingEndTime != null && (this.processingEndTime == null || update.processingEndTime > this.processingEndTime)) {
            this.processingEndTime = update.processingEndTime;
        }
        if (update.processingStartTime != null && update.processingEndTime != null) {
            long deltaDuration = update.processingEndTime - update.processingStartTime;
            this.setProcessingDurationMillis(this.getProcessingDurationMillis() + deltaDuration);
        }
        if (update.completedTime != null) {
            this.completedTime = update.completedTime;
        }
        if (update.total != null) {
            this.setTotal(update.getTotal());
        }
        if (update.getAction() != null && this.getAction() == null) {
            this.setAction(update.action);
        }
        if (update.getResult() != null) {
            this.setResult(update.getResult());
        }
        if (update.getUsername() != null && this.getUsername() == null) {
            this.setUsername(this.getUsername());
        }
        if (update.errorCount > 0L) {
            this.errorCount += update.errorCount;
        }
        if (update.errorMessage != null && this.errorMessage == null) {
            this.errorMessage = update.errorMessage;
        }
        if (update.queryLimitReached) {
            this.queryLimitReached = true;
        }
        this.checkForCompletedState();
    }

    protected void checkForCompletedState() {
        if (!this.isDelta() && this.getTotal() > 0L && this.getProcessed() >= this.getTotal() && this.getState() != State.COMPLETED && this.getState() != State.ABORTED) {
            this.setState(State.COMPLETED);
            this.setCompletedTime(Instant.now());
        }
    }

    public String getId() {
        return this.commandId;
    }

    public void setId(String id) {
        this.commandId = id;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Instant getSubmitTime() {
        return this.submitTime == null ? null : Instant.ofEpochMilli(this.submitTime);
    }

    public void setSubmitTime(@NotNull Instant submitTime) {
        this.submitTime = submitTime.toEpochMilli();
    }

    public Instant getScrollStartTime() {
        return this.scrollStartTime == null ? null : Instant.ofEpochMilli(this.scrollStartTime);
    }

    public void setScrollStartTime(@NotNull Instant scrollStartTime) {
        this.scrollStartTime = scrollStartTime.toEpochMilli();
    }

    public Instant getScrollEndTime() {
        return this.scrollEndTime == null ? null : Instant.ofEpochMilli(this.scrollEndTime);
    }

    public void setScrollEndTime(@NotNull Instant scrollEndTime) {
        this.scrollEndTime = scrollEndTime.toEpochMilli();
    }

    public Instant getProcessingStartTime() {
        return this.processingStartTime == null ? null : Instant.ofEpochMilli(this.processingStartTime);
    }

    public void setProcessingStartTime(@NotNull Instant processingStartTime) {
        this.processingStartTime = processingStartTime.toEpochMilli();
    }

    public Instant getProcessingEndTime() {
        return this.processingEndTime == null ? null : Instant.ofEpochMilli(this.processingEndTime);
    }

    public void setProcessingEndTime(@NotNull Instant processingEndTime) {
        this.processingEndTime = processingEndTime.toEpochMilli();
    }

    public Instant getCompletedTime() {
        return this.completedTime == null ? null : Instant.ofEpochMilli(this.completedTime);
    }

    public void setCompletedTime(@NotNull Instant completedTime) {
        this.completedTime = completedTime.toEpochMilli();
    }

    public boolean isQueryLimitReached() {
        return this.queryLimitReached;
    }

    public void setQueryLimitReached(boolean queryLimitReached) {
        this.queryLimitReached = queryLimitReached;
    }

    public boolean isCompleted() {
        return this.getState() == State.COMPLETED;
    }

    public long getProcessed() {
        if (this.processed == null) {
            return 0L;
        }
        return this.processed;
    }

    public void setProcessed(long processed) {
        this.processed = processed;
    }

    public long getTotal() {
        if (this.total == null) {
            return 0L;
        }
        return this.total;
    }

    public void setTotal(long count) {
        this.total = count;
    }

    public Map<String, Serializable> getResult() {
        return Collections.unmodifiableMap(this.result);
    }

    public void setResult(Map<String, Serializable> result) {
        this.result = result;
    }

    public boolean isDelta() {
        return this.delta;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getProcessingDurationMillis() {
        if (this.processingDurationMillis == null) {
            return 0L;
        }
        return this.processingDurationMillis;
    }

    public void setProcessingDurationMillis(long processingDurationMillis) {
        this.processingDurationMillis = processingDurationMillis;
    }

    public boolean hasError() {
        return this.errorCount > 0L;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public void inError(String message) {
        this.errorCount = this.isDelta() ? 1L : ++this.errorCount;
        this.errorMessage = message;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static enum State {
        UNKNOWN,
        SCHEDULED,
        SCROLLING_RUNNING,
        RUNNING,
        COMPLETED,
        ABORTED;

    }
}

