/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.SectionPublicationTree;
import org.nuxeo.runtime.api.Framework;

public class RootSectionsPublicationTree
extends SectionPublicationTree {
    private static final long serialVersionUID = 1L;
    protected DocumentModel currentDocument;
    protected RootSectionFinder rootFinder;
    protected boolean useRootSections = true;

    @Override
    public void initTree(CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String title) {
        super.initTree(coreSession, parameters, factory, configName, title);
        this.rootFinder = ((PublisherService)Framework.getService(PublisherService.class)).getRootSectionFinder(coreSession);
    }

    @Override
    public List<PublicationNode> getChildrenNodes() {
        if (this.currentDocument != null && this.useRootSections) {
            DocumentModelList rootSections = this.rootFinder.getAccessibleSectionRoots(this.currentDocument);
            if (rootSections.isEmpty()) {
                this.useRootSections = false;
                return super.getChildrenNodes();
            }
            ArrayList<PublicationNode> publicationNodes = new ArrayList<PublicationNode>();
            for (DocumentModel rootSection : rootSections) {
                if (!this.isPublicationNode(rootSection)) continue;
                publicationNodes.add(new CoreFolderPublicationNode(rootSection, this, this.rootNode, this.factory));
            }
            return publicationNodes;
        }
        return super.getChildrenNodes();
    }

    @Override
    public void setCurrentDocument(DocumentModel currentDocument) {
        this.currentDocument = currentDocument;
        this.rootFinder.reset();
        this.useRootSections = true;
    }

    @Override
    public PublicationNode getNodeByPath(String path) {
        if (!this.useRootSections) {
            return super.getNodeByPath(path);
        }
        if (path.equals(this.rootPath)) {
            return this;
        }
        List<PublicationNode> children = this.getChildrenNodes();
        for (PublicationNode child : children) {
            if (!child.getPath().equals(path)) continue;
            return child;
        }
        return super.getNodeByPath(path);
    }
}

