/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.descriptors.PublicationTreeConfigDescriptor;
import org.nuxeo.ecm.platform.publisher.descriptors.PublicationTreeDescriptor;
import org.nuxeo.ecm.platform.publisher.descriptors.PublishedDocumentFactoryDescriptor;
import org.nuxeo.ecm.platform.publisher.descriptors.RootSectionFinderFactoryDescriptor;
import org.nuxeo.ecm.platform.publisher.helper.PublicationRelationHelper;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinderFactory;
import org.nuxeo.ecm.platform.publisher.impl.finder.DefaultRootSectionsFinder;
import org.nuxeo.ecm.platform.publisher.impl.service.DomainsFinder;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRuleDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PublisherServiceImpl
extends DefaultComponent
implements PublisherService {
    private final Log log = LogFactory.getLog(PublisherServiceImpl.class);
    protected Map<String, PublicationTreeDescriptor> treeDescriptors = new HashMap<String, PublicationTreeDescriptor>();
    protected Map<String, PublishedDocumentFactoryDescriptor> factoryDescriptors = new HashMap<String, PublishedDocumentFactoryDescriptor>();
    protected Map<String, PublicationTreeConfigDescriptor> treeConfigDescriptors = new HashMap<String, PublicationTreeConfigDescriptor>();
    protected Map<String, ValidatorsRuleDescriptor> validatorsRuleDescriptors = new HashMap<String, ValidatorsRuleDescriptor>();
    protected Map<String, PublicationTreeConfigDescriptor> pendingDescriptors = new HashMap<String, PublicationTreeConfigDescriptor>();
    protected RootSectionFinderFactory rootSectionFinderFactory = null;
    public static final String TREE_EP = "tree";
    public static final String TREE_CONFIG_EP = "treeInstance";
    public static final String VALIDATORS_RULE_EP = "validatorsRule";
    public static final String FACTORY_EP = "factory";
    public static final String ROOT_SECTION_FINDER_FACTORY_EP = "rootSectionFinderFactory";
    protected static final String ROOT_PATH_KEY = "RootPath";
    protected static final String RELATIVE_ROOT_PATH_KEY = "RelativeRootPath";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ComponentContext context) {
        RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
        if (repositoryService == null) {
            return;
        }
        boolean txWasStartedOutsideComponent = TransactionHelper.isTransactionActiveOrMarkedRollback();
        if (txWasStartedOutsideComponent || TransactionHelper.startTransaction()) {
            boolean completedAbruptly = true;
            try {
                this.doApplicationStarted();
                completedAbruptly = false;
            }
            finally {
                if (completedAbruptly) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
                if (!txWasStartedOutsideComponent) {
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        } else {
            this.doApplicationStarted();
        }
    }

    protected void doApplicationStarted() {
        ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
        ClassLoader nuxeoCL = PublisherServiceImpl.class.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(nuxeoCL);
            this.log.info((Object)"Publisher Service initialization");
            this.registerPendingDescriptors();
        }
        finally {
            Thread.currentThread().setContextClassLoader(jbossCL);
            this.log.debug((Object)"JBoss ClassLoader restored");
        }
    }

    public void activate(ComponentContext context) {
        this.treeDescriptors = new HashMap<String, PublicationTreeDescriptor>();
        this.factoryDescriptors = new HashMap<String, PublishedDocumentFactoryDescriptor>();
        this.treeConfigDescriptors = new HashMap<String, PublicationTreeConfigDescriptor>();
        this.validatorsRuleDescriptors = new HashMap<String, ValidatorsRuleDescriptor>();
        this.pendingDescriptors = new HashMap<String, PublicationTreeConfigDescriptor>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.log.debug((Object)("Registry contribution for EP " + extensionPoint));
        if (TREE_EP.equals(extensionPoint)) {
            PublicationTreeDescriptor desc = (PublicationTreeDescriptor)contribution;
            this.treeDescriptors.put(desc.getName(), desc);
        } else if (TREE_CONFIG_EP.equals(extensionPoint)) {
            PublicationTreeConfigDescriptor desc = (PublicationTreeConfigDescriptor)contribution;
            this.registerTreeConfig(desc);
        } else if (FACTORY_EP.equals(extensionPoint)) {
            PublishedDocumentFactoryDescriptor desc = (PublishedDocumentFactoryDescriptor)contribution;
            this.factoryDescriptors.put(desc.getName(), desc);
        } else if (VALIDATORS_RULE_EP.equals(extensionPoint)) {
            ValidatorsRuleDescriptor desc = (ValidatorsRuleDescriptor)contribution;
            this.validatorsRuleDescriptors.put(desc.getName(), desc);
        } else if (ROOT_SECTION_FINDER_FACTORY_EP.equals(extensionPoint)) {
            RootSectionFinderFactoryDescriptor desc = (RootSectionFinderFactoryDescriptor)contribution;
            try {
                this.rootSectionFinderFactory = desc.getFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException t) {
                this.log.error((Object)"Unable to load custom RootSectionFinderFactory", (Throwable)t);
            }
        }
    }

    protected void registerTreeConfig(PublicationTreeConfigDescriptor desc) {
        if (desc.getParameters().get(RELATIVE_ROOT_PATH_KEY) != null) {
            this.pendingDescriptors.put(desc.getName(), desc);
        } else {
            this.treeConfigDescriptors.put(desc.getName(), desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof PublicationTreeDescriptor) {
            this.treeDescriptors.remove(((PublicationTreeDescriptor)contribution).getName());
        } else if (contribution instanceof PublicationTreeConfigDescriptor) {
            String name = ((PublicationTreeConfigDescriptor)contribution).getName();
            this.pendingDescriptors.remove(name);
            this.treeConfigDescriptors.remove(name);
        } else if (contribution instanceof ValidatorsRuleDescriptor) {
            this.validatorsRuleDescriptors.remove(((ValidatorsRuleDescriptor)contribution).getName());
        } else if (contribution instanceof RootSectionFinderFactoryDescriptor) {
            this.rootSectionFinderFactory = null;
        }
    }

    @Override
    public List<String> getAvailablePublicationTree() {
        ArrayList<String> treeConfigs = new ArrayList<String>();
        treeConfigs.addAll(this.treeConfigDescriptors.keySet());
        return treeConfigs;
    }

    @Override
    public Map<String, String> getAvailablePublicationTrees() {
        HashMap<String, String> trees = new HashMap<String, String>();
        for (PublicationTreeConfigDescriptor desc : this.treeConfigDescriptors.values()) {
            String title = desc.getTitle() == null ? desc.getName() : desc.getTitle();
            trees.put(desc.getName(), title);
        }
        return trees;
    }

    @Override
    public PublicationTree getPublicationTree(String treeName, CoreSession coreSession, Map<String, String> params) {
        return this.getPublicationTree(treeName, coreSession, params, null);
    }

    @Override
    public PublicationTree getPublicationTree(String treeName, CoreSession coreSession, Map<String, String> params, DocumentModel currentDocument) {
        PublicationTree tree = this.buildTree(treeName, coreSession, params);
        if (tree == null) {
            return null;
        }
        if (currentDocument != null) {
            tree.setCurrentDocument(currentDocument);
        }
        return tree;
    }

    protected PublicationTree buildTree(String treeConfigName, CoreSession coreSession, Map<String, String> params) {
        PublicationTreeConfigDescriptor config = this.getPublicationTreeConfigDescriptor(treeConfigName);
        Map<String, String> allParameters = this.computeAllParameters(config, params);
        PublicationTreeDescriptor treeDescriptor = this.getPublicationTreeDescriptor(config);
        PublishedDocumentFactory publishedDocumentFactory = this.getPublishedDocumentFactory(config, treeDescriptor, coreSession, allParameters);
        return this.getPublicationTree(treeDescriptor, coreSession, allParameters, publishedDocumentFactory, config.getName(), config.getTitle());
    }

    protected Map<String, String> computeAllParameters(PublicationTreeConfigDescriptor config, Map<String, String> params) {
        Map<String, String> allParameters = config.getParameters();
        if (params != null) {
            allParameters.putAll(params);
        }
        return allParameters;
    }

    protected PublishedDocumentFactory getPublishedDocumentFactory(PublicationTreeConfigDescriptor config, PublicationTreeDescriptor treeDescriptor, CoreSession coreSession, Map<String, String> params) {
        PublishedDocumentFactory factory;
        PublishedDocumentFactoryDescriptor factoryDesc = this.getPublishedDocumentFactoryDescriptor(config, treeDescriptor);
        ValidatorsRule validatorsRule = this.getValidatorsRule(factoryDesc);
        try {
            factory = factoryDesc.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Error while creating factory " + factoryDesc.getName(), (Throwable)e);
        }
        factory.init(coreSession, validatorsRule, params);
        return factory;
    }

    protected ValidatorsRule getValidatorsRule(PublishedDocumentFactoryDescriptor factoryDesc) {
        String validatorsRuleName = factoryDesc.getValidatorsRuleName();
        ValidatorsRule validatorsRule = null;
        if (validatorsRuleName != null) {
            ValidatorsRuleDescriptor validatorsRuleDesc = this.validatorsRuleDescriptors.get(validatorsRuleName);
            if (validatorsRuleDesc == null) {
                throw new NuxeoException("Unable to find validatorsRule" + validatorsRuleName);
            }
            try {
                validatorsRule = validatorsRuleDesc.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Error while creating validatorsRule " + validatorsRuleName, (Throwable)e);
            }
        }
        return validatorsRule;
    }

    protected PublishedDocumentFactoryDescriptor getPublishedDocumentFactoryDescriptor(PublicationTreeConfigDescriptor config, PublicationTreeDescriptor treeDescriptor) {
        PublishedDocumentFactoryDescriptor factoryDesc;
        String factoryName = config.getFactory();
        if (factoryName == null) {
            factoryName = treeDescriptor.getFactory();
        }
        if ((factoryDesc = this.factoryDescriptors.get(factoryName)) == null) {
            throw new NuxeoException("Unable to find factory" + factoryName);
        }
        return factoryDesc;
    }

    protected PublicationTreeConfigDescriptor getPublicationTreeConfigDescriptor(String treeConfigName) {
        if (!this.treeConfigDescriptors.containsKey(treeConfigName)) {
            throw new NuxeoException("Unknow treeConfig :" + treeConfigName);
        }
        return this.treeConfigDescriptors.get(treeConfigName);
    }

    protected PublicationTreeDescriptor getPublicationTreeDescriptor(PublicationTreeConfigDescriptor config) {
        String treeImplName = config.getTree();
        if (!this.treeDescriptors.containsKey(treeImplName)) {
            throw new NuxeoException("Unknow treeImplementation :" + treeImplName);
        }
        return this.treeDescriptors.get(treeImplName);
    }

    protected PublicationTree getPublicationTree(PublicationTreeDescriptor treeDescriptor, CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String treeTitle) {
        PublicationTree treeImpl;
        try {
            treeImpl = treeDescriptor.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Error while creating tree implementation", (Throwable)e);
        }
        treeImpl.initTree(coreSession, parameters, factory, configName, treeTitle);
        return treeImpl;
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) {
        return this.publish(doc, targetNode, null);
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) {
        return targetNode.getTree().publish(doc, targetNode, params);
    }

    @Override
    public void unpublish(DocumentModel doc, PublicationNode targetNode) {
        targetNode.getTree().unpublish(doc, targetNode);
    }

    @Override
    public boolean isPublishedDocument(DocumentModel documentModel) {
        return PublicationRelationHelper.isPublished(documentModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PublicationTree getPublicationTreeFor(DocumentModel doc, CoreSession coreSession) {
        PublicationTree tree = null;
        try {
            return PublicationRelationHelper.getPublicationTreeUsedForPublishing(doc, coreSession);
        }
        catch (NuxeoException e) {
            String treeName;
            this.log.error((Object)("Unable to get PublicationTree for " + doc.getPathAsString() + ". Fallback on first PublicationTree accepting this document."), (Throwable)e);
            Iterator<String> iterator = this.treeConfigDescriptors.keySet().iterator();
            do {
                if (!iterator.hasNext()) return tree;
            } while (!(tree = this.getPublicationTree(treeName = iterator.next(), coreSession, null)).isPublicationNode(doc));
        }
        return tree;
    }

    @Override
    public PublicationNode wrapToPublicationNode(DocumentModel documentModel, CoreSession coreSession) {
        for (String name : this.getAvailablePublicationTree()) {
            PublicationTree tree = this.getPublicationTree(name, coreSession, null);
            if (!tree.isPublicationNode(documentModel)) continue;
            return tree.wrapToPublicationNode(documentModel);
        }
        return null;
    }

    protected void registerPendingDescriptors() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        String repositoryName = repositoryManager.getDefaultRepositoryName();
        List<DocumentModel> domains = new DomainsFinder(repositoryName).getDomains();
        for (DocumentModel domain : domains) {
            this.registerTreeConfigFor(domain);
        }
    }

    public void registerTreeConfigFor(DocumentModel domain) {
        for (PublicationTreeConfigDescriptor desc : this.pendingDescriptors.values()) {
            PublicationTreeConfigDescriptor newDesc = new PublicationTreeConfigDescriptor(desc);
            String newTreeName = desc.getName() + "-" + domain.getName();
            newDesc.setName(newTreeName);
            Path newPath = domain.getPath();
            Map<String, String> parameters = newDesc.getParameters();
            newPath = newPath.append(parameters.remove(RELATIVE_ROOT_PATH_KEY));
            parameters.put(ROOT_PATH_KEY, newPath.toString());
            parameters.put("DomainName", domain.getTitle());
            this.treeConfigDescriptors.put(newDesc.getName(), newDesc);
        }
    }

    public void unRegisterTreeConfigFor(DocumentModel domain) {
        this.unRegisterTreeConfigFor(domain.getName());
    }

    public void unRegisterTreeConfigFor(String domainName) {
        for (PublicationTreeConfigDescriptor desc : this.pendingDescriptors.values()) {
            String treeName = desc.getName() + "-" + domainName;
            this.treeConfigDescriptors.remove(treeName);
        }
    }

    @Override
    public Map<String, String> getParametersFor(String treeConfigName) {
        PublicationTreeConfigDescriptor desc = this.treeConfigDescriptors.get(treeConfigName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (desc != null) {
            parameters.putAll(desc.getParameters());
        }
        return parameters;
    }

    @Override
    public RootSectionFinder getRootSectionFinder(CoreSession session) {
        if (this.rootSectionFinderFactory != null) {
            return this.rootSectionFinderFactory.getRootSectionFinder(session);
        }
        return new DefaultRootSectionsFinder(session);
    }
}

