/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.types.DocumentContentViews;
import org.nuxeo.ecm.platform.types.Layouts;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.TypeView;

@XObject(value="type")
public class Type {
    public static final String[] EMPTY_ACTIONS = new String[0];
    @XNode(value="@id")
    protected String id;
    @XNode(value="icon")
    protected String icon;
    @XNode(value="icon-expanded")
    protected String iconExpanded;
    @XNode(value="bigIcon")
    protected String bigIcon;
    @XNode(value="bigIcon-expanded")
    protected String bigIconExpanded;
    @XNode(value="label")
    protected String label;
    protected Map<String, SubType> allowedSubTypes = new HashMap<String, SubType>();
    @XNodeList(value="deniedSubtypes/type", type=String[].class, componentType=String.class)
    protected String[] deniedSubTypes;
    @XNode(value="default-view")
    protected String defaultView;
    @XNode(value="create-view")
    protected String createView;
    @XNode(value="edit-view")
    protected String editView;
    @XNode(value="description")
    protected String description;
    @XNode(value="category")
    protected String category;
    protected Map<String, TypeView> views;
    @XNodeList(value="actions/action", type=String[].class, componentType=String.class)
    protected String[] actions;
    @XNodeMap(value="layouts", key="@mode", type=HashMap.class, componentType=Layouts.class)
    Map<String, Layouts> layouts;
    @XNodeMap(value="contentViews", key="@category", type=HashMap.class, componentType=DocumentContentViews.class)
    protected Map<String, DocumentContentViews> contentViews;
    @XNode(value="@remove")
    protected boolean remove = false;

    protected Type(String id) {
        this.id = id;
    }

    public Type() {
    }

    @XNodeList(value="subtypes/type", type=ArrayList.class, componentType=SubType.class)
    public void addSubType(List<SubType> subTypes) {
        if (this.allowedSubTypes == null) {
            this.allowedSubTypes = new HashMap<String, SubType>();
        }
        for (SubType currentSubType : subTypes) {
            SubType subTypeToMerge = this.allowedSubTypes.get(currentSubType.name);
            if (subTypeToMerge == null) {
                this.allowedSubTypes.put(currentSubType.name, currentSubType);
                continue;
            }
            List<String> currentSubTypeHidden = currentSubType.getHidden();
            List<String> subTypeToMergeHidden = subTypeToMerge.getHidden();
            for (String hidden : currentSubTypeHidden) {
                if (subTypeToMergeHidden.contains(hidden)) continue;
                subTypeToMergeHidden.add(hidden);
            }
        }
    }

    public String[] getActions() {
        return this.actions;
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getBigIcon() {
        return this.bigIcon;
    }

    public void setBigIcon(String bigIcon) {
        this.bigIcon = bigIcon;
    }

    public String getBigIconExpanded() {
        return this.bigIconExpanded;
    }

    public void setBigIconExpanded(String bigIconExpanded) {
        this.bigIconExpanded = bigIconExpanded;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String[] getLayouts(String mode) {
        return this.getLayouts(mode, "any");
    }

    public String[] getLayouts(String mode, String defaultMode) {
        if (this.layouts != null) {
            Layouts layouts = this.layouts.get(mode);
            if (layouts == null && defaultMode != null) {
                layouts = this.layouts.get(defaultMode);
            }
            if (layouts != null) {
                return layouts.getLayouts();
            }
        }
        return null;
    }

    public Map<String, Layouts> getLayouts() {
        return Collections.unmodifiableMap(this.layouts);
    }

    public void setLayouts(Map<String, Layouts> layouts) {
        this.layouts = layouts;
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    public String getCreateView() {
        return this.createView;
    }

    public void setCreateView(String createView) {
        this.createView = createView;
    }

    public String getEditView() {
        return this.editView;
    }

    public void setEditView(String editView) {
        this.editView = editView;
    }

    public TypeView[] getViews() {
        return this.views.values().toArray(new TypeView[this.views.size()]);
    }

    @XNodeList(value="views/view", type=TypeView[].class, componentType=TypeView.class)
    public void setViews(TypeView[] views) {
        this.views = new HashMap<String, TypeView>();
        for (TypeView view : views) {
            this.views.put(view.getId(), view);
        }
    }

    public TypeView getView(String viewId) {
        return this.views.get(viewId);
    }

    public void setView(TypeView view) {
        this.views.put(view.getId(), view);
    }

    public String[] getDeniedSubTypes() {
        return this.deniedSubTypes;
    }

    public void setDeniedSubTypes(String[] deniedSubTypes) {
        this.deniedSubTypes = deniedSubTypes;
    }

    public Map<String, SubType> getAllowedSubTypes() {
        return this.allowedSubTypes;
    }

    public void setAllowedSubTypes(Map<String, SubType> allowedSubTypes) {
        this.allowedSubTypes = allowedSubTypes;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Type.class.getSimpleName());
        sb.append(" {");
        sb.append("id: ");
        sb.append(this.id);
        sb.append('}');
        return sb.toString();
    }

    public String getIconExpanded() {
        return this.iconExpanded;
    }

    public void setIconExpanded(String iconExpanded) {
        this.iconExpanded = iconExpanded;
    }

    public String[] getContentViews(String category) {
        DocumentContentViews cv;
        if (this.contentViews != null && (cv = this.contentViews.get(category)) != null) {
            return cv.getContentViewNames();
        }
        return null;
    }

    public Map<String, DocumentContentViews> getContentViews() {
        return Collections.unmodifiableMap(this.contentViews);
    }

    public void setContentViews(Map<String, DocumentContentViews> contentViews) {
        this.contentViews = contentViews;
    }

    public Type clone() {
        Map<String, DocumentContentViews> map;
        Map<String, Layouts> map2;
        String[] actions;
        String[] denied;
        Type clone = new Type();
        clone.setId(this.getId());
        clone.setIcon(this.getIcon());
        clone.setIconExpanded(this.getIconExpanded());
        clone.setBigIcon(this.getBigIcon());
        clone.setBigIconExpanded(this.getBigIconExpanded());
        clone.setLabel(this.getLabel());
        Map<String, SubType> subs = this.getAllowedSubTypes();
        if (subs != null) {
            HashMap<String, SubType> csubs = new HashMap<String, SubType>();
            for (Map.Entry<String, SubType> entry : subs.entrySet()) {
                csubs.put(entry.getKey(), entry.getValue().clone());
            }
            clone.setAllowedSubTypes(csubs);
        }
        if ((denied = this.getDeniedSubTypes()) != null) {
            clone.setDeniedSubTypes((String[])denied.clone());
        }
        clone.setDefaultView(this.getDefaultView());
        clone.setCreateView(this.getCreateView());
        clone.setEditView(this.getEditView());
        clone.setDescription(this.getDescription());
        clone.setCategory(this.getCategory());
        if (this.views != null) {
            HashMap<String, TypeView> cviews = new HashMap<String, TypeView>();
            for (Map.Entry<String, TypeView> entry : this.views.entrySet()) {
                cviews.put(entry.getKey(), entry.getValue().clone());
            }
            clone.views = cviews;
        }
        if ((actions = this.getActions()) != null) {
            clone.setActions((String[])actions.clone());
        }
        if ((map2 = this.getLayouts()) != null) {
            HashMap<String, Layouts> hashMap = new HashMap<String, Layouts>();
            for (Map.Entry<String, Layouts> item : map2.entrySet()) {
                hashMap.put(item.getKey(), item.getValue().clone());
            }
            clone.setLayouts(hashMap);
        }
        if ((map = this.getContentViews()) != null) {
            HashMap<String, DocumentContentViews> ccvs = new HashMap<String, DocumentContentViews>();
            for (Map.Entry<String, DocumentContentViews> item : map.entrySet()) {
                ccvs.put(item.getKey(), item.getValue().clone());
            }
            clone.setContentViews(ccvs);
        }
        clone.setRemove(this.getRemove());
        return clone;
    }
}

