/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import org.nuxeo.ecm.core.storage.dbs.DBSInvalidations;

public class RedisDBSInvalidations {
    private static final String MESSAGE_SEPARATOR = ":";
    private static final String ID_SEPARATOR = "/";
    private static final String ALL_DOCUMENTS = "ALL";
    private String nodeId;
    private DBSInvalidations invalidations;

    public RedisDBSInvalidations(String nodeId, DBSInvalidations invals) {
        assert (nodeId != null) : "nodeId required";
        assert (invals != null) : "invals required";
        this.nodeId = nodeId;
        this.invalidations = invals;
    }

    public RedisDBSInvalidations(String receiverNodeId, String message) {
        assert (receiverNodeId != null) : "receiverNodeId required";
        if (message == null || !message.contains(MESSAGE_SEPARATOR)) {
            throw new IllegalArgumentException("Invalid message: " + message);
        }
        String[] parts = message.split(MESSAGE_SEPARATOR, 2);
        this.nodeId = parts[0];
        if (!receiverNodeId.equals(this.nodeId)) {
            this.invalidations = this.deserializeInvalidations(parts[1]);
        }
    }

    private DBSInvalidations deserializeInvalidations(String invalsStr) {
        if (ALL_DOCUMENTS.equals(invalsStr)) {
            return new DBSInvalidations(true);
        }
        DBSInvalidations invals = new DBSInvalidations();
        for (String id : invalsStr.split(ID_SEPARATOR)) {
            invals.add(id);
        }
        return invals;
    }

    public DBSInvalidations getInvalidations() {
        return this.invalidations;
    }

    public String serialize() {
        return this.nodeId + MESSAGE_SEPARATOR + this.serializeInvalidations(this.invalidations);
    }

    private String serializeInvalidations(DBSInvalidations invals) {
        if (invals.all) {
            return ALL_DOCUMENTS;
        }
        return String.join((CharSequence)ID_SEPARATOR, invals.ids);
    }

    public String toString() {
        if (this.invalidations == null) {
            return "RedisDBSInvalidationsInvalidations(local, discarded)";
        }
        return "RedisDBSInvalidationsInvalidations(fromNode=" + this.nodeId + ", " + this.invalidations.toString() + ")";
    }
}

