/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.core.service;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.collections.api.CollectionLocationService;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.userworkspace.core.service.UserWorkspaceServiceImplComponent;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUserWorkspaceImpl
implements UserWorkspaceService,
CollectionLocationService {
    private static final long serialVersionUID = 1L;
    protected static final char ESCAPE_CHAR = '~';
    protected static final String ESCAPED_CHARS = "~/\\?&;@";
    protected volatile String targetDomainName;
    protected final int maxsize = ((PathSegmentService)Framework.getService(PathSegmentService.class)).getMaxSize();

    protected String getDomainName(CoreSession userCoreSession) {
        if (this.targetDomainName == null) {
            CoreInstance.doPrivileged((CoreSession)userCoreSession, session -> {
                String targetName = this.getComponent().getTargetDomainName();
                PathRef ref = new PathRef("/" + targetName);
                if (session.exists((DocumentRef)ref)) {
                    this.targetDomainName = targetName;
                    return;
                }
                DocumentModelList domains = session.query("select * from Domain where ecm:isTrashed = 0 order by dc:created");
                if (!domains.isEmpty()) {
                    this.targetDomainName = ((DocumentModel)domains.get(0)).getName();
                }
            });
        }
        return this.targetDomainName;
    }

    protected String getUserName(NuxeoPrincipal principal, String username) {
        if (principal != null) {
            username = principal.getActingUser();
        }
        if (NuxeoPrincipal.isTransientUsername((String)username)) {
            username = null;
        }
        if (StringUtils.isEmpty((CharSequence)username)) {
            username = null;
        }
        return username;
    }

    public List<String> getCandidateUserWorkspaceNames(String username) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.escape(username));
        this.generateCandidates(names, username, this.maxsize);
        this.generateCandidates(names, username, 30);
        return names;
    }

    protected String escape(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (ESCAPED_CHARS.indexOf(c) == -1) {
                sb.append(c);
                continue;
            }
            sb.append('~');
            if (c < '\u0010') {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        return sb.length() == string.length() ? string : sb.toString();
    }

    protected void generateCandidates(List<String> names, String username, int max) {
        String digested;
        String name = IdUtils.generateId((String)username, (String)"-", (boolean)false, (int)max);
        if (!names.contains(name)) {
            names.add(name);
        }
        if (name.length() == max && !names.contains(digested = name.substring(0, name.length() - 8) + this.digest(username, 8))) {
            names.add(digested);
        }
    }

    protected String digest(String username, int maxsize) {
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.update(username.getBytes());
            return new String(Hex.encodeHex((byte[])crypt.digest())).substring(0, maxsize);
        }
        catch (NoSuchAlgorithmException cause) {
            throw new NuxeoException("Cannot digest " + username, (Throwable)cause);
        }
    }

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, String usedUsername) {
        String domainName = this.getDomainName(userCoreSession);
        if (domainName == null) {
            return null;
        }
        return new Path("/" + domainName).append("UserWorkspaces").toString();
    }

    @Override
    public DocumentModel getCurrentUserPersonalWorkspace(String userName, DocumentModel currentDocument) {
        return this.getCurrentUserPersonalWorkspace(null, userName, currentDocument.getCoreSession());
    }

    @Override
    public DocumentModel getCurrentUserPersonalWorkspace(CoreSession userCoreSession) {
        return this.getCurrentUserPersonalWorkspace(userCoreSession.getPrincipal(), null, userCoreSession);
    }

    @Override
    @Deprecated
    public DocumentModel getCurrentUserPersonalWorkspace(CoreSession userCoreSession, DocumentModel context) {
        return this.getCurrentUserPersonalWorkspace(userCoreSession);
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(NuxeoPrincipal principal, String userName, CoreSession userCoreSession) {
        String usedUsername = this.getUserName(principal, userName);
        if (usedUsername == null) {
            return null;
        }
        PathRef rootref = this.getExistingUserWorkspaceRoot(userCoreSession, usedUsername);
        if (rootref == null) {
            return null;
        }
        PathRef uwref = this.getExistingUserWorkspace(userCoreSession, rootref, principal, usedUsername);
        return userCoreSession.getDocument((DocumentRef)uwref);
    }

    protected PathRef getExistingUserWorkspaceRoot(CoreSession session, String username) {
        String uwrPath = this.computePathUserWorkspaceRoot(session, username);
        if (uwrPath == null) {
            return null;
        }
        PathRef rootref = new PathRef(uwrPath);
        if (session.exists((DocumentRef)rootref)) {
            return rootref;
        }
        String path = (String)CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel uwsRootModel = this.doCreateUserWorkspacesRoot(session, rootref);
            DocumentModel docModel = s.getOrCreateDocument(uwsRootModel, doc -> this.initCreateUserWorkspacesRoot((CoreSession)s, (DocumentModel)doc));
            return docModel.getPathAsString();
        });
        return new PathRef(path);
    }

    protected PathRef getExistingUserWorkspace(CoreSession session, PathRef rootref, NuxeoPrincipal principal, String username) {
        PathRef freeRef = null;
        for (String name : this.getCandidateUserWorkspaceNames(username)) {
            DocumentModel uw;
            PathRef ref = new PathRef(rootref, name);
            if (session.exists((DocumentRef)ref) && session.hasPermission((DocumentRef)ref, "Everything") && Access.GRANT == (uw = session.getDocument((DocumentRef)ref)).getACP().getAccess(username, "Everything")) {
                return ref;
            }
            boolean exists = (Boolean)CoreInstance.doPrivileged((CoreSession)session, s -> s.exists((DocumentRef)ref));
            if (exists || freeRef != null) continue;
            freeRef = ref;
        }
        if (freeRef != null) {
            PathRef ref = freeRef;
            String path = (String)CoreInstance.doPrivileged((CoreSession)session, s -> {
                DocumentModel uwsModel = this.doCreateUserWorkspace(session, ref, username);
                return s.getOrCreateDocument(uwsModel, doc -> this.initCreateUserWorkspace((CoreSession)s, (DocumentModel)doc, username)).getPathAsString();
            });
            return new PathRef(path);
        }
        throw new DocumentSecurityException(username);
    }

    @Override
    public DocumentModel getUserPersonalWorkspace(NuxeoPrincipal principal, DocumentModel context) {
        return this.getCurrentUserPersonalWorkspace(principal, null, context.getCoreSession());
    }

    @Override
    public DocumentModel getUserPersonalWorkspace(String userName, DocumentModel context) {
        UnrestrictedUserWorkspaceFinder finder = new UnrestrictedUserWorkspaceFinder(userName, context);
        finder.runUnrestricted();
        return finder.getDetachedUserWorkspace();
    }

    @Override
    public boolean isUnderUserWorkspace(NuxeoPrincipal principal, String username, DocumentModel doc) {
        if (doc == null) {
            return false;
        }
        if ((username = this.getUserName(principal, username)) == null) {
            return false;
        }
        Path path = doc.getPath();
        if (path.segmentCount() < 2) {
            return false;
        }
        String domainName = this.getDomainName(doc.getCoreSession());
        if (!domainName.equals(path.segment(0))) {
            return false;
        }
        if (!"UserWorkspaces".equals(path.segment(1))) {
            return false;
        }
        if (!this.getCandidateUserWorkspaceNames(username).contains(path.segment(2))) {
            return false;
        }
        DocumentModel uws = this.getCurrentUserPersonalWorkspace(principal, username, doc.getCoreSession());
        return uws.getPath().isPrefixOf(doc.getPath());
    }

    protected String buildUserWorkspaceTitle(String userName) {
        String lastName;
        if (userName == null) {
            return null;
        }
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (userManager == null) {
            return userName;
        }
        DocumentModel userModel = userManager.getUserModel(userName);
        if (userModel == null) {
            return userName;
        }
        UserAdapter userAdapter = (UserAdapter)userModel.getAdapter(UserAdapter.class);
        if (userAdapter == null) {
            return userName;
        }
        StringBuilder title = new StringBuilder();
        String firstName = userAdapter.getFirstName();
        if (firstName != null && firstName.trim().length() > 0) {
            title.append(firstName);
        }
        if ((lastName = userAdapter.getLastName()) != null && lastName.trim().length() > 0) {
            if (title.length() > 0) {
                title.append(" ");
            }
            title.append(lastName);
        }
        if (title.length() > 0) {
            return title.toString();
        }
        return userName;
    }

    protected void notifyEvent(CoreSession coreSession, DocumentModel document, NuxeoPrincipal principal, String eventId, Map<String, Serializable> properties) {
        EventContextImpl eventContext;
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        if (document != null) {
            properties.put("repositoryName", (Serializable)((Object)document.getRepositoryName()));
            properties.put("documentLifeCycle", (Serializable)((Object)document.getCurrentLifeCycleState()));
            eventContext = new DocumentEventContext(coreSession, principal, document);
        } else {
            eventContext = new EventContextImpl(coreSession, principal);
        }
        eventContext.setProperties(properties);
        Event event = eventContext.newEvent(eventId);
        ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
    }

    protected UserWorkspaceServiceImplComponent getComponent() {
        return (UserWorkspaceServiceImplComponent)((Object)Framework.getService(UserWorkspaceServiceImplComponent.class));
    }

    protected abstract DocumentModel doCreateUserWorkspacesRoot(CoreSession var1, PathRef var2);

    protected abstract DocumentModel initCreateUserWorkspacesRoot(CoreSession var1, DocumentModel var2);

    protected abstract DocumentModel doCreateUserWorkspace(CoreSession var1, PathRef var2, String var3);

    protected abstract DocumentModel initCreateUserWorkspace(CoreSession var1, DocumentModel var2, String var3);

    @Override
    public void invalidate() {
        this.targetDomainName = null;
    }

    public DocumentModel getUserDefaultCollectionsRoot(CoreSession session) {
        DocumentModel defaultCollectionsRoot = this.createDefaultCollectionsRoot(session, this.getCurrentUserPersonalWorkspace(session));
        return session.getOrCreateDocument(defaultCollectionsRoot, doc -> this.initDefaultCollectionsRoot(session, (DocumentModel)doc));
    }

    public DocumentModel getUserFavorites(CoreSession session) {
        DocumentModel location = this.getCurrentUserPersonalWorkspace(session);
        if (location == null) {
            return null;
        }
        DocumentModel favorites = this.createFavorites(session, location);
        return session.getOrCreateDocument(favorites, doc -> this.initCreateFavorites(session, (DocumentModel)doc));
    }

    protected Locale getLocale(CoreSession session) {
        Locale locale = ((LocaleProvider)Framework.getService(LocaleProvider.class)).getLocale(session);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return new Locale(locale.getLanguage());
    }

    protected DocumentModel createFavorites(CoreSession session, DocumentModel userWorkspace) {
        String title;
        DocumentModel doc = session.createDocumentModel(userWorkspace.getPath().toString(), "Favorites", "Favorites");
        try {
            title = I18NUtils.getMessageString((String)"messages", (String)"label.myFavorites.title", (Object[])new Object[0], (Locale)this.getLocale(session));
        }
        catch (MissingResourceException e) {
            title = "Favorites";
        }
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        doc.setPropertyValue("dc:description", (Serializable)((Object)""));
        return doc;
    }

    protected DocumentModel initCreateFavorites(CoreSession session, DocumentModel favorites) {
        ACPImpl acp = new ACPImpl();
        ACE denyEverything = new ACE("Everyone", "Everything", false);
        ACE allowEverything = new ACE(session.getPrincipal().getName(), "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{allowEverything, denyEverything});
        acp.addACL((ACL)acl);
        favorites.setACP((ACP)acp, true);
        return favorites;
    }

    protected DocumentModel createDefaultCollectionsRoot(CoreSession session, DocumentModel userWorkspace) {
        String title;
        DocumentModel doc = session.createDocumentModel(userWorkspace.getPath().toString(), "Collections", "Collections");
        try {
            title = I18NUtils.getMessageString((String)"messages", (String)"label.myCollections.title", (Object[])new Object[0], (Locale)this.getLocale(session));
        }
        catch (MissingResourceException e) {
            title = "label.myCollections.title";
        }
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        doc.setPropertyValue("dc:description", (Serializable)((Object)""));
        return doc;
    }

    protected DocumentModel initDefaultCollectionsRoot(CoreSession session, DocumentModel collectionsRoot) {
        ACPImpl acp = new ACPImpl();
        ACE denyEverything = new ACE("Everyone", "Everything", false);
        ACE allowEverything = new ACE(session.getPrincipal().getName(), "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{allowEverything, denyEverything});
        acp.addACL((ACL)acl);
        collectionsRoot.setACP((ACP)acp, true);
        return collectionsRoot;
    }

    protected class UnrestrictedUserWorkspaceFinder
    extends UnrestrictedSessionRunner {
        protected DocumentModel userWorkspace;
        protected String userName;

        protected UnrestrictedUserWorkspaceFinder(String userName, DocumentModel context) {
            super(context.getCoreSession().getRepositoryName(), userName);
            this.userName = userName;
        }

        public void run() {
            this.userWorkspace = AbstractUserWorkspaceImpl.this.getCurrentUserPersonalWorkspace(null, this.userName, this.session);
            if (this.userWorkspace != null) {
                this.userWorkspace.detach(true);
            }
        }

        public DocumentModel getDetachedUserWorkspace() {
            return this.userWorkspace;
        }
    }
}

