/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.api.operation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Operation(id="WorkflowModel.BulkRestartInstances", category="Workflow Context", label="Bulk Restart Workflow", description="Bulk operation to restart workflows.", aliases={"BulkRestartWorkflow"})
public class BulkRestartWorkflow {
    public static final String ID = "WorkflowModel.BulkRestartInstances";
    private static final Log log = LogFactory.getLog(BulkRestartWorkflow.class);
    @Param(name="workflowId")
    protected String workflowId;
    @Param(name="nodeId", required=false)
    protected String nodeId;
    @Param(name="reinitLifecycle", required=false)
    protected boolean reinitLifecycle;
    @Param(name="batchSize", required=false)
    protected Integer batchSize;
    @Context
    protected OperationContext ctx;
    public static final int DEFAULT_BATCH_SIZE = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run() {
        boolean transactionStarted = false;
        try {
            CoreSession session = CoreInstance.getCoreSession(null);
            String query = "Select %s from DocumentRoute where (ecm:name like '%s.%%' OR  ecm:name like '%s') and ecm:currentLifeCycleState = 'running'";
            String key = "ecm:uuid";
            if (StringUtils.isEmpty((CharSequence)this.nodeId)) {
                if (StringUtils.isEmpty((CharSequence)this.workflowId)) {
                    log.error((Object)"Need to specify either the workflowModelId either the nodeId to query the workflows");
                    return;
                }
                query = String.format(query, key, this.workflowId, this.workflowId);
            } else {
                query = "Select %s from RouteNode  where rnode:nodeId = '%s' and ecm:currentLifeCycleState = 'suspended'";
                key = "ecm:parentId";
                if (StringUtils.isEmpty((CharSequence)this.nodeId)) {
                    log.error((Object)"Need to specify either the workflowModelId either the nodeId to query the workflows");
                    return;
                }
                query = String.format(query, key, this.nodeId);
            }
            IterableQueryResult results = session.queryAndFetch(query, "NXQL", new Object[0]);
            ArrayList<String> routeIds = new ArrayList<String>();
            for (Map result : results) {
                routeIds.add(((Serializable)result.get(key)).toString());
            }
            results.close();
            DocumentRoutingService routingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            if (this.batchSize == null) {
                this.batchSize = 1000;
            }
            if (!TransactionHelper.isTransactionActive()) {
                TransactionHelper.startTransaction();
                transactionStarted = true;
            }
            long routesRestartedCount = 0L;
            for (String routeId : routeIds) {
                try {
                    DocumentModel docRoute = session.getDocument((DocumentRef)new IdRef(routeId));
                    DocumentRoute route = (DocumentRoute)docRoute.getAdapter(DocumentRoute.class);
                    List<String> relatedDocIds = route.getAttachedDocuments();
                    route.cancel(session);
                    log.debug((Object)("Canceling workflow  " + route.getDocument().getName()));
                    if (this.reinitLifecycle) {
                        this.reinitLifecycle(relatedDocIds, session);
                    }
                    routingService.createNewInstance(this.workflowId, relatedDocIds, session, true);
                    for (String string : relatedDocIds) {
                        log.debug((Object)("Starting workflow for " + string));
                    }
                    session.removeDocument(route.getDocument().getRef());
                    if (++routesRestartedCount % (long)this.batchSize.intValue() != 0L) continue;
                    TransactionHelper.commitOrRollbackTransaction();
                    TransactionHelper.startTransaction();
                    session = CoreInstance.getCoreSession(null);
                }
                catch (NuxeoException e) {
                    Throwable t = BulkRestartWorkflow.unwrapException(e);
                    log.error((Object)(t.getClass().getSimpleName() + ": " + t.getMessage()));
                    log.error((Object)("Workflow with the docId '" + routeId + "' cannot be canceled. " + routesRestartedCount + " workflows have been processed."));
                }
            }
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
            if (!transactionStarted) {
                TransactionHelper.startTransaction();
            }
        }
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t != null) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return BulkRestartWorkflow.unwrapException(cause);
    }

    protected void reinitLifecycle(List<String> docIds, CoreSession session) {
        for (String docId : docIds) {
            session.reinitLifeCycleState((DocumentRef)new IdRef(docId));
        }
    }
}

