/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.capabilities;

import java.util.Optional;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;

public class ServerInfo {
    protected String distributionName;
    protected String distributionVersion;
    protected String distributionServer;
    protected String hotfixVersion;
    protected boolean clusterEnabled;
    protected String clusterNodeId;

    protected ServerInfo() {
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public String getDistributionVersion() {
        return this.distributionVersion;
    }

    public String getDistributionServer() {
        return this.distributionServer;
    }

    public Optional<String> getHotfixVersion() {
        return Optional.ofNullable(this.hotfixVersion);
    }

    public boolean isClusterEnabled() {
        return this.clusterEnabled;
    }

    public String getClusterNodeId() {
        return this.clusterNodeId;
    }

    public static ServerInfo get() {
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        ServerInfo info = new ServerInfo();
        info.distributionName = Framework.getProperty((String)"org.nuxeo.distribution.name");
        info.distributionVersion = Framework.getProperty((String)"org.nuxeo.distribution.version");
        info.distributionServer = Framework.getProperty((String)"org.nuxeo.distribution.server");
        info.hotfixVersion = Framework.getProperty((String)"org.nuxeo.distribution.hotfix");
        info.clusterEnabled = clusterService.isEnabled();
        info.clusterNodeId = clusterService.getNodeId();
        return info;
    }
}

