/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.capabilities;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.common.function.ThrowableConsumer;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.restapi.jaxrs.io.capabilities.ServerInfo;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ServerInfoJsonWriter
extends ExtensibleEntityJsonWriter<ServerInfo> {
    public static final String ENTITY_TYPE = "server";

    public ServerInfoJsonWriter() {
        super(ENTITY_TYPE, ServerInfo.class);
    }

    protected void writeEntityBody(ServerInfo entity, JsonGenerator jg) throws IOException {
        jg.writeStringField("distributionName", entity.getDistributionName());
        jg.writeStringField("distributionVersion", entity.getDistributionVersion());
        jg.writeStringField("distributionServer", entity.getDistributionServer());
        entity.getHotfixVersion().ifPresent(ThrowableConsumer.asConsumer(h -> jg.writeStringField("hotfixVersion", h)));
        jg.writeBooleanField("clusterEnabled", entity.isClusterEnabled());
        jg.writeStringField("clusterNodeId", entity.getClusterNodeId());
    }
}

