/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.blob.AESBlobStoreConfiguration;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.LocalBlobStore;
import org.nuxeo.ecm.core.blob.PathStrategy;

public class AESBlobStore
extends LocalBlobStore {
    protected static final byte[] FILE_MAGIC = "NUXEOCRYPT".getBytes(StandardCharsets.US_ASCII);
    protected static final int FILE_VERSION_1 = 1;
    protected static final int USE_KEYSTORE = 1;
    protected static final int USE_PBKDF2 = 2;
    private static final int MAX_SALT_LEN = 1024;
    private static final int MAX_IV_LEN = 1024;
    protected static final Random RANDOM = new SecureRandom();
    protected final AESBlobStoreConfiguration aesConfig;

    public AESBlobStore(String name, KeyStrategy keyStrategy, PathStrategy pathStrategy, AESBlobStoreConfiguration aesConfig) {
        super(name, keyStrategy, pathStrategy);
        this.aesConfig = aesConfig;
    }

    @Override
    protected void write(BlobWriteContext blobWriteContext, Path file) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));
             EncryptingOutputStream cryptOut = new EncryptingOutputStream(out, this.aesConfig);){
            this.transfer(blobWriteContext, cryptOut);
        }
    }

    @Override
    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        return BlobStore.OptionalOrUnknown.unknown();
    }

    @Override
    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        BlobStore.OptionalOrUnknown<InputStream> streamOpt = super.getStream(key);
        if (!streamOpt.isPresent()) {
            return streamOpt;
        }
        try {
            InputStream in = streamOpt.get();
            try {
                return BlobStore.OptionalOrUnknown.of(new DecryptingInputStream(in, this.aesConfig));
            }
            catch (IOException e) {
                in.close();
                throw e;
            }
        }
        catch (NoSuchFileException e) {
            return BlobStore.OptionalOrUnknown.missing();
        }
    }

    @Override
    public boolean readBlob(String key, Path dest) throws IOException {
        BlobStore.OptionalOrUnknown<InputStream> streamOpt = this.getStream(key);
        if (streamOpt.isPresent()) {
            try (InputStream stream = streamOpt.get();){
                Files.copy(stream, dest, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        if (streamOpt.isMissing()) {
            return false;
        }
        throw new IllegalStateException("stream should always be known");
    }

    @Override
    public boolean copyBlobIsOptimized(BlobStore sourceStore) {
        return false;
    }

    @Override
    public boolean copyBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static class DecryptingInputStream
    extends FilterInputStream {
        protected final AESBlobStoreConfiguration aesConfig;

        public DecryptingInputStream(InputStream in, AESBlobStoreConfiguration aesConfig) throws IOException {
            super(in);
            this.aesConfig = aesConfig;
            this.readHeader();
        }

        protected void readHeader() throws IOException {
            Cipher cipher;
            byte[] magic = new byte[FILE_MAGIC.length];
            IOUtils.read((InputStream)this.in, (byte[])magic);
            if (!Arrays.equals(magic, FILE_MAGIC)) {
                throw new IOException("Invalid file (bad magic)");
            }
            DataInputStream data = new DataInputStream(this.in);
            byte magicvers = data.readByte();
            if (magicvers != 1) {
                throw new IOException("Invalid file (bad version)");
            }
            byte usepb = data.readByte();
            if (usepb == 2) {
                if (!this.aesConfig.usePBKDF2) {
                    throw new IOException("File requires PBKDF2 password");
                }
            } else if (usepb == 1) {
                if (this.aesConfig.usePBKDF2) {
                    throw new IOException("File requires keystore");
                }
            } else {
                throw new IOException("Invalid file (bad use)");
            }
            try {
                Key secret;
                if (this.aesConfig.usePBKDF2) {
                    int saltLen = data.readInt();
                    if (saltLen <= 0 || saltLen > 1024) {
                        throw new IOException("Invalid salt length: " + saltLen);
                    }
                    byte[] salt = new byte[saltLen];
                    data.read(salt, 0, saltLen);
                    secret = this.aesConfig.generateSecretKey(salt);
                } else {
                    secret = this.aesConfig.getSecretKey();
                }
                int ivLen = data.readInt();
                if (ivLen <= 0 || ivLen > 1024) {
                    throw new IOException("Invalid IV length: " + ivLen);
                }
                byte[] iv = new byte[ivLen];
                data.read(iv, 0, ivLen);
                cipher = this.aesConfig.getCipher();
                cipher.init(2, secret, this.aesConfig.getParameterSpec(iv));
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.in = new CipherInputStream(this.in, cipher);
        }
    }

    public static class EncryptingOutputStream
    extends FilterOutputStream {
        protected final AESBlobStoreConfiguration aesConfig;

        public EncryptingOutputStream(OutputStream out, AESBlobStoreConfiguration aesConfig) throws IOException {
            super(out);
            this.aesConfig = aesConfig;
            this.writeHeader();
        }

        protected void writeHeader() throws IOException {
            Cipher cipher;
            this.out.write(FILE_MAGIC);
            DataOutputStream data = new DataOutputStream(this.out);
            data.writeByte(1);
            try {
                Key secret;
                if (this.aesConfig.usePBKDF2) {
                    data.writeByte(2);
                    byte[] salt = new byte[16];
                    RANDOM.nextBytes(salt);
                    secret = this.aesConfig.generateSecretKey(salt);
                    data.writeInt(salt.length);
                    data.write(salt);
                } else {
                    data.writeByte(1);
                    secret = this.aesConfig.getSecretKey();
                }
                cipher = this.aesConfig.getCipher();
                cipher.init(1, secret);
                byte[] iv = cipher.getIV();
                data.writeInt(iv.length);
                data.write(iv);
                data.flush();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.out = new CipherOutputStream(this.out, cipher);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }
}

