/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.time.Duration;
import java.util.Calendar;

public class BlobUpdateContext {
    public final String key;
    public UpdateRetainUntil updateRetainUntil;
    public UpdateLegalHold updateLegalHold;
    public RestoreForDuration restoreForDuration;

    public BlobUpdateContext(String key) {
        this.key = key;
    }

    public BlobUpdateContext with(BlobUpdateContext other) {
        if (other.updateRetainUntil != null) {
            this.updateRetainUntil = other.updateRetainUntil;
        }
        if (other.updateLegalHold != null) {
            this.updateLegalHold = other.updateLegalHold;
        }
        if (other.restoreForDuration != null) {
            this.restoreForDuration = other.restoreForDuration;
        }
        return this;
    }

    public BlobUpdateContext withUpdateRetainUntil(Calendar retainUntil) {
        this.updateRetainUntil = new UpdateRetainUntil(retainUntil);
        return this;
    }

    public BlobUpdateContext withUpdateLegalHold(boolean hold) {
        this.updateLegalHold = new UpdateLegalHold(hold);
        return this;
    }

    public BlobUpdateContext withRestoreForDuration(Duration duration) {
        this.restoreForDuration = new RestoreForDuration(duration);
        return this;
    }

    public static class RestoreForDuration {
        public final Duration duration;

        public RestoreForDuration(Duration duration) {
            this.duration = duration;
        }
    }

    public static class UpdateLegalHold {
        public final boolean hold;

        public UpdateLegalHold(boolean hold) {
            this.hold = hold;
        }
    }

    public static class UpdateRetainUntil {
        public final Calendar retainUntil;

        public UpdateRetainUntil(Calendar retainUntil) {
            this.retainUntil = retainUntil;
        }
    }
}

