/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.blob.DigestConfiguration;
import org.nuxeo.ecm.core.blob.PropertyBasedConfiguration;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerRootDescriptor;
import org.nuxeo.runtime.api.Framework;

public class LocalBlobStoreConfiguration
extends PropertyBasedConfiguration {
    public static final String PROP_PATH = "path";
    public static final Pattern WINDOWS_ABSOLUTE_PATH = Pattern.compile("[a-zA-Z]:[/\\\\].*");
    public static final String DEFAULT_PATH = "binaries";
    public static final String DATA = "data";
    public static final String TMP = "tmp";
    public static final String CONFIG_FILE = "config.xml";
    public final Path storageDir;
    public final Path tmpDir;
    public final BinaryManagerRootDescriptor descriptor;
    public final DigestConfiguration digestConfiguration;
    public static final int DEFAULT_DEPTH = 2;

    public LocalBlobStoreConfiguration(Map<String, String> properties) throws IOException {
        super(null, properties);
        Path base = this.getStorageBase();
        this.storageDir = base.resolve(DATA);
        this.tmpDir = base.resolve(TMP);
        Files.createDirectories(this.storageDir, new FileAttribute[0]);
        Files.createDirectories(this.tmpDir, new FileAttribute[0]);
        this.descriptor = this.getDescriptor(base.resolve(CONFIG_FILE), true);
        this.digestConfiguration = new DigestConfiguration(null, properties);
    }

    public Path getStorageBase() {
        Path base;
        String path = this.getProperty(PROP_PATH, DEFAULT_PATH);
        path = Framework.expandVars((String)path);
        if ((path = path.trim()).startsWith("/") || path.startsWith("\\") || path.contains("://") || path.contains(":\\") || WINDOWS_ABSOLUTE_PATH.matcher(path).matches()) {
            base = Paths.get(path, new String[0]);
        } else {
            Path home = Environment.getDefault().getData().toPath();
            base = home.resolve(path).normalize();
        }
        String namespace = this.getProperty("namespace");
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            base = base.resolveSibling(base.getFileName() + "_" + namespace.trim());
        }
        return base;
    }

    public BinaryManagerRootDescriptor getDescriptor(Path configFile, boolean create) throws IOException {
        BinaryManagerRootDescriptor desc;
        if (Files.exists(configFile, new LinkOption[0])) {
            XMap xmap = new XMap();
            xmap.register(BinaryManagerRootDescriptor.class);
            desc = (BinaryManagerRootDescriptor)xmap.load(Files.newInputStream(configFile, new OpenOption[0]));
        } else {
            desc = new BinaryManagerRootDescriptor();
            desc.digest = "MD5";
            desc.depth = 2;
            if (create) {
                desc.write(configFile.toFile());
            }
        }
        return desc;
    }
}

