/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.core.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.nuxeo.ecm.web.resources.api.Processor;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.ResourceBundle;
import org.nuxeo.ecm.web.resources.api.ResourceContext;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.ecm.web.resources.core.ProcessorDescriptor;
import org.nuxeo.ecm.web.resources.core.ResourceDescriptor;
import org.nuxeo.ecm.web.resources.core.service.ProcessorRegistry;
import org.nuxeo.ecm.web.resources.core.service.ResourceBundleRegistry;
import org.nuxeo.ecm.web.resources.core.service.ResourceRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class WebResourceManagerImpl
extends DefaultComponent
implements WebResourceManager {
    private static final Log log = LogFactory.getLog(WebResourceManagerImpl.class);
    protected static final String RESOURCES_ENDPOINT = "resources";
    protected ResourceRegistry resources;
    protected static final String RESOURCE_BUNDLES_ENDPOINT = "bundles";
    protected ResourceBundleRegistry resourceBundles;
    protected static final String PROCESSORS_ENDPOINT = "processors";
    protected ProcessorRegistry processors;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.resources = new ResourceRegistry();
        this.resourceBundles = new ResourceBundleRegistry();
        this.processors = new ProcessorRegistry();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RESOURCES_ENDPOINT.equals(extensionPoint)) {
            ResourceDescriptor resource = (ResourceDescriptor)contribution;
            this.computeResourceUri(resource, contributor);
            this.registerResource(resource);
        } else if (RESOURCE_BUNDLES_ENDPOINT.equals(extensionPoint)) {
            ResourceBundle bundle = (ResourceBundle)contribution;
            this.registerResourceBundle(bundle);
        } else if (PROCESSORS_ENDPOINT.equals(extensionPoint)) {
            ProcessorDescriptor p = (ProcessorDescriptor)contribution;
            log.info((Object)String.format("Register processor '%s'", p.getName()));
            this.processors.addContribution(p);
            log.info((Object)String.format("Done registering processor '%s'", p.getName()));
        } else {
            log.error((Object)String.format("Unknown contribution to the service, extension point '%s': '%s", extensionPoint, contribution));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RESOURCES_ENDPOINT.equals(extensionPoint)) {
            Resource resource = (Resource)contribution;
            this.unregisterResource(resource);
        } else if (RESOURCE_BUNDLES_ENDPOINT.equals(extensionPoint)) {
            ResourceBundle bundle = (ResourceBundle)contribution;
            this.unregisterResourceBundle(bundle);
        } else if (PROCESSORS_ENDPOINT.equals(extensionPoint)) {
            ProcessorDescriptor p = (ProcessorDescriptor)contribution;
            log.info((Object)String.format("Removing processor '%s'", p.getName()));
            this.processors.removeContribution(p);
            log.info((Object)String.format("Done removing processor '%s'", p.getName()));
        } else {
            log.error((Object)String.format("Unknown contribution to the service, extension point '%s': '%s", extensionPoint, contribution));
        }
    }

    protected void computeResourceUri(ResourceDescriptor resource, ComponentInstance contributor) {
        String path;
        String uri = resource.getURI();
        if (uri == null && (path = resource.getPath()) != null) {
            URL url;
            boolean hasWildcard = false;
            if (path.endsWith("*")) {
                hasWildcard = true;
                path = path.substring(0, path.length() - 1);
            }
            if ((url = contributor.getContext().getLocalResource(path)) == null) {
                log.error((Object)("Cannot resolve local URL for resource '" + resource.getName() + "' with path '" + resource.getPath() + "'"));
            } else {
                Object builtUri = url.toString();
                if (hasWildcard) {
                    builtUri = (String)builtUri + "*";
                }
                resource.setURI((String)builtUri);
            }
        }
    }

    public Resource getResource(String name) {
        return this.resources.getResource(name);
    }

    public ResourceBundle getResourceBundle(String name) {
        return this.resourceBundles.getResourceBundle(name);
    }

    public List<ResourceBundle> getResourceBundles() {
        return this.resourceBundles.getResourceBundles();
    }

    public Processor getProcessor(String name) {
        return this.processors.getProcessor(name);
    }

    public List<Processor> getProcessors() {
        return this.processors.getProcessors();
    }

    public List<Processor> getProcessors(String type) {
        return this.processors.getProcessors(type);
    }

    public List<Resource> getResources(ResourceContext context, String bundleName, String type) {
        Resource r;
        ArrayList<Resource> res = new ArrayList<Resource>();
        ResourceBundle rb = this.resourceBundles.getResourceBundle(bundleName);
        if (rb == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unknown bundle named '%s'", bundleName));
            }
            return res;
        }
        HashMap<String, Resource> all = new HashMap<String, Resource>();
        DAG graph = new DAG();
        for (String rn : rb.getResources()) {
            r = this.getResource(rn);
            if (r == null) {
                log.error((Object)String.format("Could not resolve resource '%s' on bundle '%s'", rn, bundleName));
                continue;
            }
            Map<String, Resource> subRes = this.getSubResources(graph, r, type);
            if (!ResourceType.matches((String)type, (Resource)r) && subRes.isEmpty()) continue;
            graph.addVertex(rn);
            all.put(rn, r);
            all.putAll(subRes);
        }
        for (String rn : TopologicalSorter.sort((DAG)graph)) {
            r = (Resource)all.get(rn);
            if (!ResourceType.matches((String)type, (Resource)r)) continue;
            res.add(r);
        }
        return res;
    }

    protected Map<String, Resource> getSubResources(DAG graph, Resource r, String type) {
        HashMap<String, Resource> res = new HashMap<String, Resource>();
        List deps = r.getDependencies();
        if (deps != null) {
            for (String dn : deps) {
                Resource d = this.getResource(dn);
                if (d == null) {
                    log.error((Object)("Unknown resource dependency named '" + dn + "'"));
                    continue;
                }
                if (!ResourceType.matches((String)type, (Resource)d)) continue;
                res.put(dn, d);
                try {
                    graph.addEdge(r.getName(), dn);
                }
                catch (CycleDetectedException e) {
                    log.error((Object)"Cycle detected in resource dependencies: ", (Throwable)e);
                    break;
                }
                res.putAll(this.getSubResources(graph, d, type));
            }
        }
        return res;
    }

    public void registerResourceBundle(ResourceBundle bundle) {
        log.info((Object)String.format("Register resource bundle '%s'", bundle.getName()));
        if (bundle.getResources().removeIf(StringUtils::isBlank)) {
            log.error((Object)("Some resources references were null or blank while setting " + bundle.getName() + " and have been supressed. This probably happened because some <resource> tags were empty in the xml declaration. The correct form is <resource>resource name</resource>."));
        }
        this.resourceBundles.addContribution(bundle);
        log.info((Object)String.format("Done registering resource bundle '%s'", bundle.getName()));
        this.setModifiedNow();
    }

    public void unregisterResourceBundle(ResourceBundle bundle) {
        log.info((Object)String.format("Removing resource bundle '%s'", bundle.getName()));
        this.resourceBundles.removeContribution(bundle);
        log.info((Object)String.format("Done removing resource bundle '%s'", bundle.getName()));
        this.setModifiedNow();
    }

    public void registerResource(Resource resource) {
        log.info((Object)String.format("Register resource '%s'", resource.getName()));
        this.resources.addContribution(resource);
        log.info((Object)String.format("Done registering resource '%s'", resource.getName()));
        this.setModifiedNow();
    }

    public void unregisterResource(Resource resource) {
        log.info((Object)String.format("Removing resource '%s'", resource.getName()));
        this.resources.removeContribution(resource);
        log.info((Object)String.format("Done removing resource '%s'", resource.getName()));
        this.setModifiedNow();
    }
}

