/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.query.sql.NXQL;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class PublicationJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "publications";

    public PublicationJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        int resultCount;
        jg.writeObjectFieldStart(NAME);
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            String escapedId = NXQL.escapeString((String)document.getId());
            resultCount = wrapper.getSession().queryProjection(String.format("SELECT * FROM Document WHERE ecm:isProxy = 1 AND (rend:sourceVersionableId = %s OR ecm:proxyVersionableId = %s)", escapedId, escapedId), 0L, 0L).size();
        }
        jg.writeNumberField("resultsCount", resultCount);
        jg.writeEndObject();
    }
}

