/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.lazy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.lazy.AbstractLazyCachableRenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractRenditionBuilderWork
extends TransientStoreWork {
    private static final long serialVersionUID = 1L;
    protected final String key;
    protected final DocumentRef docRef;
    protected final String renditionName;
    private static final Logger log = LogManager.getLogger(AbstractRenditionBuilderWork.class);
    public static final String CATEGORY = "renditionBuilder";

    public AbstractRenditionBuilderWork(String key, DocumentModel doc, RenditionDefinition def) {
        this.key = key;
        this.docRef = doc.getRef();
        this.repositoryName = doc.getRepositoryName();
        this.renditionName = def.getName();
        this.setOriginatingUsername(doc.getPrincipal().getName());
        this.id = this.buildId(doc, def);
    }

    protected String buildId(DocumentModel doc, RenditionDefinition def) {
        StringBuilder sb = new StringBuilder("rendition:");
        sb.append(doc.getId());
        String variant = def.getProvider().getVariant(doc, def);
        if (variant != null) {
            sb.append("::");
            sb.append(variant);
        }
        sb.append("::");
        sb.append(def.getName());
        return sb.toString();
    }

    public String getTitle() {
        return "Lazy Rendition for " + this.renditionName + " on " + this.docRef.toString() + " on behalf of " + this.originatingUsername;
    }

    public String getCategory() {
        return CATEGORY;
    }

    protected String getTransientStoreName() {
        return "LazyRenditionCache";
    }

    public boolean isIdempotent() {
        return false;
    }

    public boolean isCoalescing() {
        return true;
    }

    public void work() {
        log.debug("Starting work: {} with id: {} for transient store key: {} and document: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.id, (Object)this.key, (Object)this.docRef);
        this.openUserSession();
        DocumentModel doc = this.session.getDocument(this.docRef);
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition def = rs.getAvailableRenditionDefinition(doc, this.renditionName);
        log.debug("Starting rendition computation.");
        List<Blob> blobs = this.doComputeRendition(this.session, doc, def);
        this.updateAndCompleteStoreEntry(this.getSourceDocumentModificationDate(doc), blobs);
    }

    public void cleanUp(boolean ok, Exception e) {
        try {
            if (!ok) {
                this.storeAnErrorRendition();
            }
        }
        finally {
            super.cleanUp(ok, e);
        }
    }

    protected void storeAnErrorRendition() {
        if (this.session == null) {
            log.info("No session, unable to clean work: {} with id: {} for transient store key: {} and document: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.id, (Object)this.key, (Object)this.docRef);
            return;
        }
        DocumentModel doc = this.session.getDocument(this.docRef);
        String sourceDocumentModificationDate = this.getSourceDocumentModificationDate(doc);
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        StringBlob emptyBlob = new StringBlob("");
        emptyBlob.setFilename("error");
        emptyBlob.setMimeType("text/plain;error=true");
        blobs.add((Blob)emptyBlob);
        this.updateAndCompleteStoreEntry(sourceDocumentModificationDate, blobs);
    }

    void updateAndCompleteStoreEntry(String sourceDocumentModificationDate, List<Blob> blobs) {
        log.debug("Updating and completing transient store entry with key: {} (workId: {}, document: {})", (Object)this.key, (Object)this.id, (Object)this.docRef);
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(this.getTransientStoreName());
        log.debug("BEGIN - Putting blobs for transient store entry with key: {}", (Object)this.key);
        ts.putBlobs(this.key, blobs);
        log.debug("END - Putting blobs for transient store entry with key: {}", (Object)this.key);
        if (sourceDocumentModificationDate != null) {
            log.debug("Updating source document modification date parameter to: {} for transient store entry with key: {}", (Object)sourceDocumentModificationDate, (Object)this.key);
            ts.putParameter(this.key, "sourceDocumentModificationDate", (Serializable)((Object)sourceDocumentModificationDate));
        }
        ts.setCompleted(this.key, true);
    }

    protected String getSourceDocumentModificationDate(DocumentModel doc) {
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition definition = rs.getAvailableRenditionDefinition(doc, this.renditionName);
        RenditionProvider provider = definition.getProvider();
        if (provider instanceof AbstractLazyCachableRenditionProvider) {
            return ((AbstractLazyCachableRenditionProvider)provider).getSourceDocumentModificationDate(doc, definition);
        }
        return null;
    }

    protected abstract List<Blob> doComputeRendition(CoreSession var1, DocumentModel var2, RenditionDefinition var3);
}

