/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.datasource.DataSourceDescriptor;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.DataSourceLinkDescriptor;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DataSourceComponent
extends DefaultComponent {
    private final Log log = LogFactory.getLog(DataSourceComponent.class);
    public static final String DATASOURCES_XP = "datasources";
    public static final String ENV_CTX_NAME = "java:comp/env/";
    protected Map<String, DataSourceDescriptor> datasources = new HashMap<String, DataSourceDescriptor>();
    protected Map<String, DataSourceLinkDescriptor> links = new HashMap<String, DataSourceLinkDescriptor>();
    protected final PooledDataSourceRegistry poolRegistry = new PooledDataSourceRegistry();
    protected boolean started;

    public void activate(ComponentContext context) {
        this.datasources = new HashMap<String, DataSourceDescriptor>();
        this.links = new HashMap<String, DataSourceLinkDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.links = null;
        this.datasources = null;
    }

    public void registerContribution(Object contrib, String extensionPoint, ComponentInstance component) {
        if (contrib instanceof DataSourceDescriptor) {
            this.addDataSource((DataSourceDescriptor)contrib);
        } else if (contrib instanceof DataSourceLinkDescriptor) {
            this.addDataSourceLink((DataSourceLinkDescriptor)contrib);
        } else {
            this.log.error((Object)("Wrong datasource extension type " + contrib.getClass().getName()));
        }
    }

    public void unregisterContribution(Object contrib, String extensionPoint, ComponentInstance component) {
        if (contrib instanceof DataSourceDescriptor) {
            this.removeDataSource((DataSourceDescriptor)contrib);
        } else if (contrib instanceof DataSourceLinkDescriptor) {
            this.removeDataSourceLink((DataSourceLinkDescriptor)contrib);
        }
    }

    public int getApplicationStartedOrder() {
        return -1000;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start(ComponentContext context) {
        if (this.started) {
            return;
        }
        this.started = true;
        for (DataSourceDescriptor datasourceDesc : this.datasources.values()) {
            this.bindDataSource(datasourceDesc);
        }
        for (DataSourceLinkDescriptor linkDesc : this.links.values()) {
            this.bindDataSourceLink(linkDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ComponentContext context) {
        try {
            for (DataSourceLinkDescriptor dataSourceLinkDescriptor : this.links.values()) {
                this.unbindDataSourceLink(dataSourceLinkDescriptor);
            }
            for (DataSourceDescriptor dataSourceDescriptor : this.datasources.values()) {
                this.unbindDataSource(dataSourceDescriptor);
            }
        }
        finally {
            this.started = false;
        }
    }

    protected void addDataSource(DataSourceDescriptor contrib) {
        this.datasources.put(contrib.getName(), contrib);
        this.bindDataSource(contrib);
    }

    protected void removeDataSource(DataSourceDescriptor contrib) {
        this.unbindDataSource(contrib);
        this.datasources.remove(contrib.getName());
    }

    protected void bindDataSource(DataSourceDescriptor descr) {
        this.log.info((Object)("Registering datasource: " + descr.getName()));
        this.poolRegistry.registerPooledDataSource(descr.getName(), descr.getAllProperties());
    }

    protected void unbindDataSource(DataSourceDescriptor descr) {
        this.log.info((Object)("Unregistering datasource: " + descr.getName()));
        this.poolRegistry.unregisterPooledDataSource(descr.getName());
    }

    protected void addDataSourceLink(DataSourceLinkDescriptor contrib) {
        this.links.put(contrib.name, contrib);
        this.bindDataSourceLink(contrib);
    }

    protected void removeDataSourceLink(DataSourceLinkDescriptor contrib) {
        this.unbindDataSourceLink(contrib);
        this.links.remove(contrib.name);
    }

    protected void bindDataSourceLink(DataSourceLinkDescriptor descr) {
        DataSource ds;
        this.log.info((Object)("Registering DataSourceLink: " + descr.name));
        try {
            ds = DataSourceHelper.getDataSource(descr.global, DataSource.class);
        }
        catch (NamingException e) {
            throw new RuntimeServiceException("Cannot find DataSourceLink '" + descr.name + "' in JNDI", (Throwable)e);
        }
        this.poolRegistry.createAlias(DataSourceHelper.relativize(descr.name), ds);
    }

    protected void unbindDataSourceLink(DataSourceLinkDescriptor descr) {
        this.log.info((Object)("Unregistering DataSourceLink: " + descr.name));
        this.poolRegistry.removeAlias(descr.name);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(PooledDataSourceRegistry.class)) {
            return adapter.cast(this.poolRegistry);
        }
        return (T)super.getAdapter(adapter);
    }
}

