/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.tokens;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoOAuth2TokenWriter
extends ExtensibleEntityJsonWriter<NuxeoOAuth2Token> {
    public static final String ENTITY_TYPE = "nuxeoOAuth2Token";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public NuxeoOAuth2TokenWriter() {
        super(ENTITY_TYPE, NuxeoOAuth2Token.class);
    }

    protected void writeEntityBody(NuxeoOAuth2Token token, JsonGenerator jg) throws IOException {
        String[] sharedWith;
        jg.writeStringField("serviceName", token.getServiceName());
        jg.writeStringField("nuxeoLogin", token.getNuxeoLogin());
        jg.writeStringField("serviceLogin", token.getServiceLogin());
        jg.writeStringField("clientId", token.getClientId());
        jg.writeBooleanField("isShared", token.isShared());
        jg.writeArrayFieldStart("sharedWith");
        String sharedWithStr = token.getSharedWith();
        for (String user : sharedWith = sharedWithStr == null ? new String[]{} : token.getSharedWith().split(",")) {
            jg.writeString(user.trim());
        }
        jg.writeEndArray();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        Calendar cal = token.getCreationDate();
        jg.writeStringField("creationDate", dateFormat.format(cal == null ? null : cal.getTime()));
    }
}

