/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URLEncodedUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.UnboundEventContext;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.login.PrincipalImpl;
import org.nuxeo.ecm.platform.ui.web.auth.CachableUserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoSecuredRequestWrapper;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.LoginResponseHandler;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.ui.web.auth.service.AuthenticationPluginDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.OpenUrlDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.web.common.session.NuxeoHttpSessionMonitor;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginComponent;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentManager;

public class NuxeoAuthenticationFilter
implements Filter {
    private static final Log log = LogFactory.getLog(NuxeoAuthenticationFilter.class);
    @Deprecated
    public static final String DEFAULT_START_PAGE = "nxstartup.faces";
    public static final String LOGIN_DOMAIN = "nuxeo-ecm-web";
    protected static final String XMLHTTP_REQUEST_TYPE = "XMLHttpRequest";
    protected static final String LOGIN_CATEGORY = "NuxeoAuthentication";
    protected static final Principal DIRECTORY_ERROR_PRINCIPAL = new PrincipalImpl("__DIRECTORY_ERROR__\u0000\u0000\u0000");
    protected static final String INDEX_JSP = "index.jsp";
    protected static final String SLASH_INDEX_JSP = "/index.jsp";
    protected static final String CONVERSATION_ID = "conversationId";
    protected volatile PluggableAuthenticationService service;
    protected ReentrantReadWriteLock unAuthenticatedURLPrefixLock = new ReentrantReadWriteLock();
    protected List<String> unAuthenticatedURLPrefix;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Timer requestTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"web", "authentication", "requests", "timer"}));
    protected final Counter concurrentCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"web", "authentication", "requests", "concurrency"}));
    protected final Counter concurrentMaxCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"web", "authentication", "requests", "concurrency", "max"}));
    protected final Counter loginCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"web", "authentication", "logged-users"}));

    public void destroy() {
    }

    protected static boolean sendAuthenticationEvent(UserIdentificationInfo userInfo, String eventId, String comment) {
        return (Boolean)Framework.doPrivileged(() -> {
            EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
            UserPrincipal principal = new UserPrincipal(userInfo.getUserName(), null, false, false);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("AuthenticationPlugin", userInfo.getAuthPluginName());
            props.put("category", LOGIN_CATEGORY);
            props.put("comment", comment);
            UnboundEventContext ctx = new UnboundEventContext((NuxeoPrincipal)principal, props);
            evtProducer.fireEvent(ctx.newEvent(eventId));
            return true;
        });
    }

    protected boolean logAuthenticationAttempt(UserIdentificationInfo userInfo, boolean success) {
        String comment;
        String eventId;
        String userName = userInfo.getUserName();
        if (userName == null || userName.length() == 0) {
            userName = userInfo.getToken();
        }
        if (success) {
            eventId = "loginSuccess";
            comment = userName + " successfully logged in using " + userInfo.getAuthPluginName() + " authentication";
            this.loginCount.inc();
        } else {
            eventId = "loginFailed";
            comment = userName + " failed to authenticate using " + userInfo.getAuthPluginName() + " authentication";
        }
        return NuxeoAuthenticationFilter.sendAuthenticationEvent(userInfo, eventId, comment);
    }

    protected boolean logLogout(UserIdentificationInfo userInfo) {
        this.loginCount.dec();
        String userName = userInfo.getUserName();
        if (userName == null || userName.length() == 0) {
            userName = userInfo.getToken();
        }
        String eventId = "logout";
        String comment = userName + " logged out";
        return NuxeoAuthenticationFilter.sendAuthenticationEvent(userInfo, eventId, comment);
    }

    protected Principal doAuthenticate(CachableUserIdentificationInfo cachableUserIdent, HttpServletRequest httpRequest) {
        UserIdentificationInfo userIdent = cachableUserIdent.getUserInfo();
        Principal principal = this.getPrincipalCheckingAuth(userIdent, httpRequest);
        if (principal == null || principal == DIRECTORY_ERROR_PRINCIPAL) {
            return principal;
        }
        NuxeoLoginContext loginContext = NuxeoLoginContext.create((Principal)principal);
        loginContext.login();
        cachableUserIdent.setPrincipal(principal);
        cachableUserIdent.setLoginContext((LoginContext)loginContext);
        this.logAuthenticationAttempt(userIdent, true);
        httpRequest.setAttribute("org.nuxeo.ecm.login.context", (Object)loginContext);
        boolean createSession = this.needSessionSaving(userIdent);
        HttpSession session = httpRequest.getSession(createSession);
        if (session != null) {
            session.setAttribute("org.nuxeo.ecm.login.identity", (Object)cachableUserIdent);
        }
        this.service.onAuthenticatedSessionCreated((ServletRequest)httpRequest, session, cachableUserIdent);
        return principal;
    }

    protected boolean switchUser(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String deputyLogin = (String)httpRequest.getAttribute("deputy");
        String targetPageAfterSwitch = (String)httpRequest.getAttribute("pageAfterSwitch");
        if (targetPageAfterSwitch == null) {
            targetPageAfterSwitch = LoginScreenHelper.getStartupPagePath();
        }
        CachableUserIdentificationInfo cachableUserIdent = NuxeoAuthenticationFilter.retrieveIdentityFromCache(httpRequest);
        String originatingUser = cachableUserIdent.getUserInfo().getUserName();
        if (deputyLogin == null) {
            NuxeoPrincipal currentPrincipal = (NuxeoPrincipal)cachableUserIdent.getPrincipal();
            String previousUser = currentPrincipal.getOriginatingUser();
            if (previousUser == null) {
                return false;
            }
            deputyLogin = previousUser;
            originatingUser = null;
        }
        try {
            cachableUserIdent.getLoginContext().logout();
        }
        catch (LoginException e1) {
            log.error((Object)"Error while logout from main identity", (Throwable)e1);
        }
        httpRequest.getSession(false);
        this.service.reinitSession(httpRequest);
        CachableUserIdentificationInfo newCachableUserIdent = new CachableUserIdentificationInfo(deputyLogin, deputyLogin);
        newCachableUserIdent.getUserInfo().setAuthPluginName(cachableUserIdent.getUserInfo().getAuthPluginName());
        Principal principal = this.doAuthenticate(newCachableUserIdent, httpRequest);
        if (principal != null && principal != DIRECTORY_ERROR_PRINCIPAL) {
            NuxeoPrincipal nxUser = (NuxeoPrincipal)principal;
            if (originatingUser != null) {
                nxUser.setOriginatingUser(originatingUser);
            }
            NuxeoLoginContext loginContext = NuxeoLoginContext.create((Principal)cachableUserIdent.getPrincipal());
            loginContext.login();
        }
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)Boolean.TRUE);
        String baseURL = this.service.getBaseURL(request);
        ((HttpServletResponse)response).sendRedirect(baseURL + targetPageAfterSwitch);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try (Timer.Context contextTimer = this.requestTimer.time();){
            this.concurrentCount.inc();
            if (this.concurrentCount.getCount() > this.concurrentMaxCount.getCount()) {
                this.concurrentMaxCount.inc();
            }
            try {
                this.doInitIfNeeded();
                this.doFilterInternal(request, response, chain);
            }
            finally {
                LoginComponent.clearPrincipalStack();
                this.concurrentCount.dec();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean result;
        if (this.bypassAuth((HttpServletRequest)request)) {
            chain.doFilter(request, response);
            return;
        }
        String tokenPage = NuxeoAuthenticationFilter.getRequestedPage(request);
        if (tokenPage.equals("swuser") && (result = this.switchUser(request, response, chain))) {
            return;
        }
        if (request instanceof NuxeoSecuredRequestWrapper) {
            log.debug((Object)"ReEntering Nuxeo Authentication Filter ... exiting directly");
            chain.doFilter(request, response);
            return;
        }
        if (this.service.canBypassRequest(request)) {
            log.debug((Object)"ReEntering Nuxeo Authentication Filter after URL rewrite ... exiting directly");
            chain.doFilter(request, response);
            return;
        }
        log.debug((Object)"Entering Nuxeo Authentication Filter");
        String targetPageURL = null;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Principal principal = httpRequest.getUserPrincipal();
        NuxeoLoginContext propagatedAuthCb = null;
        String forceAnonymousLoginParam = httpRequest.getParameter("forceAnonymousLogin");
        boolean forceAnonymousLogin = Boolean.parseBoolean(forceAnonymousLoginParam);
        String anonymousId = this.getAnonymousId();
        try {
            if (principal == null) {
                log.debug((Object)"Principal not found inside Request via getUserPrincipal");
                log.debug((Object)"Try getting authentication from cache");
                CachableUserIdentificationInfo cachableUserIdent = NuxeoAuthenticationFilter.retrieveIdentityFromCache(httpRequest);
                if (cachableUserIdent != null) {
                    if (forceAnonymousLogin && cachableUserIdent.getUserInfo().getUserName().equals(anonymousId)) {
                        cachableUserIdent = null;
                    }
                    if (this.service.needResetLogin(request)) {
                        HttpSession session = httpRequest.getSession(false);
                        if (session != null) {
                            session.removeAttribute("org.nuxeo.ecm.login.identity");
                        }
                        this.service.invalidateSession(request);
                        cachableUserIdent = null;
                    }
                }
                if (cachableUserIdent != null) {
                    log.debug((Object)"userIdent found in cache, get the Principal from it without reloggin");
                    NuxeoHttpSessionMonitor.instance().updateEntry(httpRequest);
                    principal = cachableUserIdent.getPrincipal();
                    log.debug((Object)("Principal = " + principal.getName()));
                    propagatedAuthCb = NuxeoLoginContext.create((Principal)cachableUserIdent.getPrincipal());
                    propagatedAuthCb.login();
                    String requestedPage = NuxeoAuthenticationFilter.getRequestedPage(httpRequest);
                    if ("logout".equals(requestedPage)) {
                        boolean redirected = this.handleLogout(request, response, cachableUserIdent);
                        cachableUserIdent = null;
                        principal = null;
                        if (redirected && httpRequest.getParameter("form_submitted_marker") == null) {
                            return;
                        }
                    } else if ("login".equals(requestedPage)) {
                        if (this.handleLogin(httpRequest, httpResponse)) {
                            return;
                        }
                    } else {
                        targetPageURL = NuxeoAuthenticationFilter.getSavedRequestedURL(httpRequest, httpResponse);
                    }
                }
                if (cachableUserIdent == null) {
                    UserIdentificationInfo userIdent = this.handleRetrieveIdentity(httpRequest, httpResponse);
                    if (userIdent != null) {
                        String userName = userIdent.getUserName();
                        if (userName.equals("system")) {
                            this.buildUnauthorizedResponse(httpRequest, httpResponse);
                            return;
                        }
                        if (forceAnonymousLogin && userName.equals(anonymousId)) {
                            userIdent = null;
                        }
                    }
                    if (userIdent == null && !this.bypassAuth(httpRequest)) {
                        boolean res = this.handleLoginPrompt(httpRequest, httpResponse);
                        if (res) {
                            return;
                        }
                    } else {
                        String redirectUrl = VirtualHostHelper.getRedirectUrl(httpRequest);
                        HttpSession session = httpRequest.getSession(false);
                        if (session != null) {
                            session.setAttribute("redirect_url", (Object)redirectUrl);
                        }
                        targetPageURL = NuxeoAuthenticationFilter.getSavedRequestedURL(httpRequest, httpResponse);
                    }
                    if (userIdent != null) {
                        cachableUserIdent = new CachableUserIdentificationInfo(userIdent);
                        principal = this.doAuthenticate(cachableUserIdent, httpRequest);
                        if (principal != null && principal != DIRECTORY_ERROR_PRINCIPAL) {
                            propagatedAuthCb = NuxeoLoginContext.create((Principal)cachableUserIdent.getPrincipal());
                            propagatedAuthCb.login();
                            NuxeoAuthenticationPlugin plugin = this.getAuthenticator(cachableUserIdent);
                            if (plugin instanceof LoginResponseHandler && ((LoginResponseHandler)((Object)plugin)).onSuccess((HttpServletRequest)request, (HttpServletResponse)response)) {
                                return;
                            }
                        } else {
                            NuxeoAuthenticationPlugin plugin = this.getAuthenticator(cachableUserIdent);
                            if (plugin instanceof LoginResponseHandler) {
                                if (((LoginResponseHandler)((Object)plugin)).onError((HttpServletRequest)request, (HttpServletResponse)response)) {
                                    return;
                                }
                            } else {
                                String err = principal == DIRECTORY_ERROR_PRINCIPAL ? "connection.error" : "authentication.failed";
                                httpRequest.setAttribute("org.nuxeo.ecm.login.error", (Object)err);
                                boolean res = this.handleLoginPrompt(httpRequest, httpResponse);
                                if (res) {
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            if (principal != null) {
                if (targetPageURL != null && targetPageURL.length() > 0) {
                    String baseURL = this.service.getBaseURL(request);
                    if (XMLHTTP_REQUEST_TYPE.equalsIgnoreCase(httpRequest.getHeader("X-Requested-With"))) {
                        return;
                    }
                    String redirectUrl = URI.create(baseURL).resolve(targetPageURL).toString();
                    httpResponse.sendRedirect(redirectUrl);
                    return;
                }
                chain.doFilter((ServletRequest)new NuxeoSecuredRequestWrapper(httpRequest, principal), response);
            } else {
                chain.doFilter(request, response);
            }
        }
        finally {
            if (propagatedAuthCb != null) {
                propagatedAuthCb.close();
            }
        }
        log.debug((Object)"Exit Nuxeo Authentication filter");
    }

    public NuxeoAuthenticationPlugin getAuthenticator(CachableUserIdentificationInfo ci) {
        String key = ci.getUserInfo().getAuthPluginName();
        if (key != null) {
            NuxeoAuthenticationPlugin authPlugin = this.service.getPlugin(key);
            return authPlugin;
        }
        return null;
    }

    protected static CachableUserIdentificationInfo retrieveIdentityFromCache(HttpServletRequest httpRequest) {
        CachableUserIdentificationInfo cachableUserInfo;
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (cachableUserInfo = (CachableUserIdentificationInfo)session.getAttribute("org.nuxeo.ecm.login.identity")) != null) {
            return cachableUserInfo;
        }
        return null;
    }

    protected String getAnonymousId() {
        return ((UserManager)Framework.getService(UserManager.class)).getAnonymousUserId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitIfNeeded() throws ServletException {
        if (this.service == null && Framework.getRuntime() != null) {
            NuxeoAuthenticationFilter nuxeoAuthenticationFilter = this;
            synchronized (nuxeoAuthenticationFilter) {
                if (this.service != null) {
                    return;
                }
                PluggableAuthenticationService svc = (PluggableAuthenticationService)((Object)Framework.getService(PluggableAuthenticationService.class));
                new ComponentManager.Listener(){

                    public void beforeStart(ComponentManager mgr, boolean isResume) {
                        NuxeoAuthenticationFilter.this.service = null;
                        this.uninstall();
                    }
                }.install();
                this.service = svc;
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public boolean saveRequestedURLBeforeRedirect(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        boolean isSW;
        String requestPage;
        boolean isTimeout;
        boolean hasRequestedSessionId = !StringUtils.isBlank((CharSequence)httpRequest.getRequestedSessionId());
        HttpSession session = httpRequest.getSession(false);
        boolean bl = isTimeout = session == null && hasRequestedSessionId;
        if (!httpResponse.isCommitted()) {
            session = httpRequest.getSession(true);
        }
        if (session == null) {
            return false;
        }
        boolean requestPageInParams = false;
        if (httpRequest.getParameter("requestedUrl") != null) {
            requestPageInParams = true;
            requestPage = httpRequest.getParameter("requestedUrl");
        } else {
            requestPage = NuxeoAuthenticationFilter.getRequestedUrl(httpRequest);
        }
        if (requestPage == null) {
            return false;
        }
        if (isTimeout && !requestPage.equals(LoginScreenHelper.getStartupPagePath())) {
            session.setAttribute("nxtimeout", (Object)Boolean.TRUE);
        } else {
            session.removeAttribute("nxtimeout");
        }
        boolean bl2 = isSW = httpRequest.getHeader("service-worker") != null;
        if (this.isStartPageValid(requestPage) && !isSW) {
            if (!requestPageInParams) {
                Object uri = URIUtils.getURIPath((String)requestPage);
                if (requestPage.contains("?")) {
                    Map params = URIUtils.getRequestParameters((String)requestPage);
                    params.remove("forceAnonymousLogin");
                    if (!params.isEmpty()) {
                        uri = (String)uri + "?" + URIUtils.getURIQuery((Map)params);
                    }
                }
                session.setAttribute("Nuxeo5_Start_Page", uri);
            }
            return true;
        }
        for (String startupPagePath : LoginScreenHelper.getStartupPagePaths()) {
            if (!requestPage.startsWith(startupPagePath) || !LoginScreenHelper.getStartupPagePath().equals(startupPagePath)) continue;
            return true;
        }
        return false;
    }

    public static String getRequestedUrl(HttpServletRequest request) {
        Object path = NuxeoAuthenticationFilter.getRequestedPage(request);
        try {
            path = new URI(null, null, (String)path, null).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String qs = request.getQueryString();
        if (StringUtils.isNotEmpty((CharSequence)qs)) {
            List list;
            if (qs.contains(CONVERSATION_ID) && (list = URLEncodedUtils.parse((String)qs, (Charset)StandardCharsets.UTF_8)).removeIf(pair -> pair.getName().equals(CONVERSATION_ID))) {
                qs = URLEncodedUtils.format((Iterable)list, (Charset)StandardCharsets.UTF_8);
            }
            if (!qs.isEmpty()) {
                path = (String)path + "?" + qs;
            }
        }
        return path;
    }

    protected static String getSavedRequestedURL(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Cookie[] cookies;
        HttpSession session = httpRequest.getSession(false);
        String requestedPage = httpRequest.getParameter("requestedUrl");
        if (StringUtils.isBlank((CharSequence)requestedPage)) {
            if (session != null) {
                requestedPage = (String)session.getAttribute("Nuxeo5_Start_Page");
            }
            if ((cookies = httpRequest.getCookies()) != null) {
                for (Cookie cookie : cookies) {
                    if (!"sso.initial.url.request".equals(cookie.getName())) continue;
                    requestedPage = cookie.getValue();
                    cookie.setPath("/");
                    cookie.setMaxAge(0);
                    httpResponse.addCookie(cookie);
                }
            }
        }
        if (requestedPage != null && (cookies = httpRequest.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!"nuxeo.start.url.fragment".equals(cookie.getName())) continue;
                try {
                    requestedPage = UriBuilder.fromUri((String)requestedPage).fragment(URLDecoder.decode(cookie.getValue(), "UTF-8")).build(new Object[0]).toString();
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Failed to decode start page url fragment", (Throwable)e);
                }
                cookie.setMaxAge(0);
                httpResponse.addCookie(cookie);
            }
        }
        if (session != null) {
            session.removeAttribute("Nuxeo5_Start_Page");
        }
        return requestedPage;
    }

    protected boolean isStartPageValid(String startPage) {
        if (startPage == null) {
            return false;
        }
        try {
            this.doInitIfNeeded();
        }
        catch (ServletException e) {
            return false;
        }
        for (String prefix : this.service.getStartURLPatterns()) {
            if (!startPage.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean handleLogout(ServletRequest request, ServletResponse response, CachableUserIdentificationInfo cachedUserInfo) throws ServletException {
        String requestedUrl;
        this.logLogout(cachedUserInfo.getUserInfo());
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)Boolean.TRUE);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String securityError = request.getParameter("securityError");
        if (securityError != null) {
            parameters.put("securityError", securityError);
        }
        if (cachedUserInfo.getPrincipal().getName().equals(this.getAnonymousId())) {
            parameters.put("forceAnonymousLogin", "true");
        }
        if ((requestedUrl = request.getParameter("requestedUrl")) != null) {
            parameters.put("requestedUrl", requestedUrl);
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Cookie cookie = new Cookie("JSESSIONID", null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        httpResponse.addCookie(cookie);
        NuxeoAuthenticationPlugin authPlugin = this.getAuthenticator(cachedUserInfo);
        NuxeoAuthenticationPluginLogoutExtension logoutPlugin = null;
        if (authPlugin instanceof NuxeoAuthenticationPluginLogoutExtension) {
            logoutPlugin = (NuxeoAuthenticationPluginLogoutExtension)((Object)authPlugin);
        }
        boolean redirected = false;
        if (logoutPlugin != null) {
            redirected = Boolean.TRUE.equals(logoutPlugin.handleLogout((HttpServletRequest)request, (HttpServletResponse)response));
        }
        this.service.invalidateSession(request);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!redirected && !XMLHTTP_REQUEST_TYPE.equalsIgnoreCase(httpRequest.getHeader("X-Requested-With"))) {
            String baseURL = this.service.getBaseURL(request);
            String callbackURL = request.getParameter("callbackURL");
            try {
                httpResponse.sendRedirect(this.getLogoutRedirectURL(callbackURL, baseURL, parameters));
                redirected = true;
            }
            catch (IOException e) {
                log.error((Object)("Unable to redirect to default start page after logout : " + e.getMessage()));
            }
        }
        try {
            cachedUserInfo.getLoginContext().logout();
        }
        catch (LoginException e) {
            log.error((Object)("Unable to logout " + e.getMessage()));
        }
        return redirected;
    }

    protected String getLogoutRedirectURL(String callbackURL, String baseURL, Map<String, String> parameters) {
        if (this.isCallbackURLValid(callbackURL, baseURL)) {
            return callbackURL;
        }
        String url = baseURL + LoginScreenHelper.getStartupPagePath();
        return URIUtils.addParametersToURIQuery((String)url, parameters);
    }

    protected boolean isCallbackURLValid(String callbackURL, String baseURL) {
        return StringUtils.isNotBlank((CharSequence)callbackURL) && (baseURL != null && callbackURL.startsWith(baseURL) || callbackURL.startsWith("nuxeo://") || callbackURL.startsWith("nxdrive://"));
    }

    protected void initUnAuthenticatedURLPrefix() {
        this.unAuthenticatedURLPrefix = new ArrayList<String>();
        for (String pluginName : this.service.getAuthChain()) {
            NuxeoAuthenticationPlugin plugin = this.service.getPlugin(pluginName);
            if (plugin == null) {
                throw new NullPointerException("Could not find plugin for name '" + pluginName + "'");
            }
            List<String> prefix = plugin.getUnAuthenticatedURLPrefix();
            if (prefix == null || prefix.isEmpty()) continue;
            this.unAuthenticatedURLPrefix.addAll(prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bypassAuth(HttpServletRequest httpRequest) {
        if (this.unAuthenticatedURLPrefix == null) {
            try {
                this.unAuthenticatedURLPrefixLock.writeLock().lock();
                this.initUnAuthenticatedURLPrefix();
            }
            finally {
                this.unAuthenticatedURLPrefixLock.writeLock().unlock();
            }
        }
        try {
            this.unAuthenticatedURLPrefixLock.readLock().lock();
            String requestPage = NuxeoAuthenticationFilter.getRequestedPage(httpRequest);
            for (String prefix : this.unAuthenticatedURLPrefix) {
                if (!requestPage.startsWith(prefix)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.unAuthenticatedURLPrefixLock.readLock().unlock();
        }
        List<OpenUrlDescriptor> openUrls = this.service.getOpenUrls();
        for (OpenUrlDescriptor openUrl : openUrls) {
            if (!openUrl.allowByPassAuth(httpRequest)) continue;
            return true;
        }
        return false;
    }

    public static String getRequestedPage(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            return NuxeoAuthenticationFilter.getRequestedPage(httpRequest);
        }
        return null;
    }

    protected static String getRequestedPage(HttpServletRequest httpRequest) {
        String info;
        Object path = (String)httpRequest.getAttribute("ORIGINAL_PATH");
        if (path == null) {
            path = httpRequest.getServletPath();
        }
        if (((String)path).endsWith(SLASH_INDEX_JSP) && !httpRequest.getRequestURI().contains(SLASH_INDEX_JSP)) {
            path = ((String)path).substring(0, ((String)path).length() - INDEX_JSP.length());
        }
        if ((info = httpRequest.getPathInfo()) != null) {
            path = (String)path + info;
        }
        if (!((String)path).isEmpty()) {
            path = ((String)path).substring(1);
        }
        return path;
    }

    protected boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (!this.service.doHandlePrompt(httpRequest)) {
            this.buildUnauthorizedResponse(httpRequest, httpResponse);
            return true;
        }
        return this.handleLogin(httpRequest, httpResponse);
    }

    protected boolean handleLogin(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String baseURL = this.service.getBaseURL((ServletRequest)httpRequest);
        for (String pluginName : this.service.getAuthChain(httpRequest)) {
            NuxeoAuthenticationPlugin plugin = this.service.getPlugin(pluginName);
            AuthenticationPluginDescriptor descriptor = this.service.getDescriptor(pluginName);
            if (plugin == null) {
                throw new NullPointerException("Could not find plugin for name '" + pluginName + "'");
            }
            if (!Boolean.TRUE.equals(plugin.needLoginPrompt(httpRequest))) continue;
            if (descriptor.getNeedStartingURLSaving()) {
                this.saveRequestedURLBeforeRedirect(httpRequest, httpResponse);
            }
            HttpServletResponseWrapper response = new HttpServletResponseWrapper(httpResponse){

                public void sendRedirect(String location) throws IOException {
                    Map parameters = URIUtils.getRequestParameters((String)location);
                    if (parameters.containsKey("loginMissing") || parameters.containsKey("loginFailed")) {
                        super.sendRedirect(location);
                        return;
                    }
                    HttpServletResponse response = (HttpServletResponse)this.getResponse();
                    StringBuilder sb = new StringBuilder();
                    sb.append("<script type=\"text/javascript\">\n").append("document.cookie = '").append("nuxeo.start.url.fragment").append("=' + encodeURIComponent(window.location.hash.substring(1) || '') + '; path=/';\n").append("window.location = '").append(location).append("';\n");
                    sb.append("</script>");
                    String script = sb.toString();
                    response.setStatus(401);
                    response.setContentType("text/html;charset=UTF-8");
                    response.setContentLength(script.length());
                    response.getWriter().write(script);
                }
            };
            return Boolean.TRUE.equals(plugin.handleLoginPrompt(httpRequest, (HttpServletResponse)response, baseURL));
        }
        log.warn((Object)"No auth plugin can be found to do the Login Prompt");
        return false;
    }

    protected void buildUnauthorizedResponse(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String loginUrl = VirtualHostHelper.getBaseURL((ServletRequest)req) + "login";
            resp.addHeader("Location", loginUrl);
            resp.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
            resp.getWriter().write("Please log in at: " + loginUrl);
        }
        catch (IOException e) {
            log.error((Object)"Unable to write login page on unauthorized response", (Throwable)e);
        }
    }

    protected UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        UserIdentificationInfo userIdent = null;
        for (String pluginName : this.service.getAuthChain(httpRequest)) {
            NuxeoAuthenticationPlugin plugin = this.service.getPlugin(pluginName);
            if (plugin != null) {
                log.debug((Object)("Trying to retrieve userIdentification using plugin " + pluginName));
                userIdent = plugin.handleRetrieveIdentity(httpRequest, httpResponse);
                if (userIdent == null) continue;
                userIdent.setAuthPluginName(pluginName);
                break;
            }
            log.error((Object)("Auth plugin " + pluginName + " can not be retrieved from service"));
        }
        if (userIdent == null) {
            CachableUserIdentificationInfo savedUserInfo;
            log.debug((Object)"user/password not found in request, try into identity cache");
            HttpSession session = httpRequest.getSession(false);
            if (session == null && httpRequest.isRequestedSessionIdValid()) {
                session = httpRequest.getSession(true);
            }
            if (session != null && (savedUserInfo = NuxeoAuthenticationFilter.retrieveIdentityFromCache(httpRequest)) != null) {
                log.debug((Object)("Found User identity in cache :" + savedUserInfo.getUserInfo().getUserName()));
                userIdent = new UserIdentificationInfo(savedUserInfo.getUserInfo());
                savedUserInfo.setPrincipal(null);
            }
        } else {
            log.debug((Object)"User/Password found as parameter of the request");
        }
        return userIdent;
    }

    protected boolean needSessionSaving(UserIdentificationInfo userInfo) {
        String pluginName = userInfo.getAuthPluginName();
        AuthenticationPluginDescriptor desc = this.service.getDescriptor(pluginName);
        if (desc.getStateful()) {
            return true;
        }
        return desc.getNeedStartingURLSaving();
    }

    public static NuxeoLoginContext loginAs(String username) throws LoginException {
        NuxeoPrincipal principal = NuxeoAuthenticationFilter.createPrincipal(username);
        NuxeoLoginContext loginContext = NuxeoLoginContext.create((Principal)principal);
        loginContext.login();
        return loginContext;
    }

    protected static NuxeoPrincipal createPrincipal(String username) throws LoginException {
        NuxeoPrincipalImpl principal;
        UserManager manager = (UserManager)Framework.getService(UserManager.class);
        if (manager == null) {
            principal = new NuxeoPrincipalImpl(username);
        } else {
            principal = (NuxeoPrincipal)Framework.doPrivileged(() -> manager.getPrincipal(username));
            if (principal == null) {
                throw new LoginException(String.format("principal %s does not exist", username));
            }
        }
        return principal;
    }

    protected Principal getPrincipalCheckingAuth(UserIdentificationInfo userIdent, HttpServletRequest request) {
        try {
            String username;
            if (userIdent.credentialsChecked()) {
                username = userIdent.getUserName();
            } else {
                try {
                    UserManager manager = (UserManager)Framework.getService(UserManager.class);
                    boolean authenticated = manager.checkUsernamePassword(userIdent.getUserName(), userIdent.getPassword());
                    username = authenticated ? userIdent.getUserName() : null;
                }
                catch (DirectoryException e) {
                    throw (LoginException)new LoginException("Unable to validate identity").initCause(e);
                }
            }
            if (username == null) {
                throw new LoginException("Unable to validate identity for " + userIdent.getUserName());
            }
            return NuxeoAuthenticationFilter.createPrincipal(username);
        }
        catch (LoginException e) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Login failed for %s on request %s", userIdent.getUserName(), request.getRequestURI()));
            }
            log.debug((Object)e, (Throwable)e);
            this.logAuthenticationAttempt(userIdent, false);
            Throwable cause = e.getCause();
            if (cause instanceof DirectoryException) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
                if (rootCause instanceof NamingException && rootCause.getMessage().contains("LDAP response read timed out") || rootCause instanceof SocketException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Exception root cause is either a NamingException with \"LDAP response read timed out\" or a SocketException, setting the status code to %d, more relevant than an illegitimate 401.", 504));
                    }
                    request.setAttribute("org.nuxeo.ecm.login.status.code", (Object)504);
                }
                return DIRECTORY_ERROR_PRINCIPAL;
            }
            return null;
        }
    }
}

