/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.util.Collection;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public abstract class BaseSession
implements Session<QueryFilter> {
    private static final Logger log = LogManager.getLogger(BaseSession.class);
    public static final String VERSION_ACL_DISABLED_PROP = "org.nuxeo.version.acl.disabled";
    public static final String READ_VERSION_PERM_DISABLED_PROP = "org.nuxeo.version.readversion.disabled";
    protected final Repository repository;
    protected final VersionAclMode versionAclMode;
    protected final boolean disableReadVersionPermission;

    public static boolean isReadVersionPermissionDisabled() {
        if (!Framework.isInitialized()) {
            return false;
        }
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        return configurationService.isBooleanTrue(READ_VERSION_PERM_DISABLED_PROP);
    }

    protected BaseSession(Repository repository) {
        this.repository = repository;
        this.versionAclMode = VersionAclMode.getConfiguration();
        this.disableReadVersionPermission = BaseSession.isReadVersionPermissionDisabled();
    }

    protected DocumentBlobManager getDocumentBlobManager() {
        return (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
    }

    protected void notifyAfterCopy(Document doc) {
        this.getDocumentBlobManager().notifyAfterCopy(doc);
    }

    protected void checkNegativeAcl(ACP acp) {
        if (acp == null || this.isNegativeAclAllowed()) {
            return;
        }
        for (ACL acl : acp.getACLs()) {
            if (acl.getName().equals("inherited")) continue;
            for (ACE ace : acl.getACEs()) {
                String permission;
                if (ace.isGranted() || (permission = ace.getPermission()).equals("Everything") && ace.getUsername().equals("Everyone") || permission.equals("Write")) continue;
                throw new IllegalArgumentException("Negative ACL not allowed: " + ace);
            }
        }
    }

    public abstract ACP getACP(Document var1);

    protected ACP getACP(Document doc, boolean replaceReadVersionPermission) {
        ACP acp = this.getACP(doc);
        if (acp != null && replaceReadVersionPermission) {
            acp.replacePermission("ReadVersion", "Read");
        }
        return acp;
    }

    public ACP getMergedACP(Document doc) {
        ACP acp;
        boolean replaceReadVersionPermission = false;
        if (doc.isVersion()) {
            boolean bl = replaceReadVersionPermission = !this.disableReadVersionPermission;
            if (this.versionAclMode != VersionAclMode.ENABLED && (doc = doc.getSourceDocument()) == null) {
                return null;
            }
        }
        ACP mergedAcp = acp = this.getACP(doc, replaceReadVersionPermission);
        ACLImpl inherited = new ACLImpl("inherited", true);
        while (acp == null || acp.getAccess("Everyone", "Everything") != Access.DENY) {
            if (doc.isVersion()) {
                replaceReadVersionPermission = !this.disableReadVersionPermission;
                doc = doc.getSourceDocument();
            } else {
                doc = doc.getParent();
            }
            if (doc == null) break;
            acp = this.getACP(doc, replaceReadVersionPermission);
            if (acp == null) continue;
            inherited.addAll((Collection)acp.getMergedACLs("inherited"));
        }
        if (!inherited.isEmpty()) {
            if (mergedAcp == null) {
                mergedAcp = new ACPImpl();
            }
            mergedAcp.addACL((ACL)inherited);
        }
        return mergedAcp;
    }

    protected ACP updateACP(ACP curAcp, ACP addAcp) {
        String name;
        if (curAcp == null) {
            return addAcp;
        }
        ACP newAcp = curAcp.clone();
        HashMap<String, ACL> acls = new HashMap<String, ACL>();
        for (ACL acl : newAcp.getACLs()) {
            name = acl.getName();
            if ("inherited".equals(name)) {
                throw new IllegalStateException(curAcp.toString());
            }
            acls.put(name, acl);
        }
        for (ACL acl : addAcp.getACLs()) {
            name = acl.getName();
            if ("inherited".equals(name)) continue;
            ACL curAcl = (ACL)acls.get(name);
            if (curAcl != null) {
                curAcl.addAll((Collection)acl);
                continue;
            }
            newAcp.addACL(acl);
        }
        return newAcp;
    }

    public static enum VersionAclMode {
        ENABLED,
        DISABLED,
        LEGACY;


        public static VersionAclMode getConfiguration() {
            String val;
            if (!Framework.isInitialized()) {
                return ENABLED;
            }
            ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
            switch (val = configurationService.getString(BaseSession.VERSION_ACL_DISABLED_PROP).orElse("false")) {
                case "false": {
                    return ENABLED;
                }
                case "true": {
                    return DISABLED;
                }
                case "legacy": {
                    return LEGACY;
                }
            }
            log.error("Invalid value for configuration property {}: '{}'", (Object)BaseSession.VERSION_ACL_DISABLED_PROP, (Object)val);
            return ENABLED;
        }
    }
}

