/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.PoolConfiguration;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RepositoryService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.repository.RepositoryService");
    public static final String CLUSTER_START_DURATION_PROP = "org.nuxeo.repository.cluster.start.duration";
    public static final Duration CLUSTER_START_DURATION_DEFAULT = Duration.ofMinutes(1L);
    private static final Log log = LogFactory.getLog(RepositoryService.class);
    public static final String XP_REPOSITORY = "repository";
    private final Map<String, org.nuxeo.ecm.core.model.Repository> repositories = new ConcurrentHashMap<String, org.nuxeo.ecm.core.model.Repository>();
    protected GenericKeyedObjectPool<String, Session> basePool;
    protected PoolConfiguration poolConfig;
    protected KeyedObjectPool<String, Session> pool;
    protected static final Map<String, ThreadLocal<Session>> SESSIONS = new ConcurrentHashMap<String, ThreadLocal<Session>>(1);

    public void shutdown() {
        log.info((Object)"Shutting down repository manager");
        this.repositories.values().forEach(org.nuxeo.ecm.core.model.Repository::shutdown);
        this.repositories.clear();
    }

    public int getApplicationStartedOrder() {
        return 100;
    }

    public void start(ComponentContext context) {
        this.initPool();
        TransactionHelper.runInTransaction(this::doCreateRepositories);
        Framework.getRuntime().getComponentManager().addListener(new ComponentManager.Listener(){

            public void afterStart(ComponentManager mgr, boolean isResume) {
                RepositoryService.this.initRepositories();
            }

            public void afterStop(ComponentManager mgr, boolean isStandby) {
                Framework.getRuntime().getComponentManager().removeListener((ComponentManager.Listener)this);
            }
        });
    }

    public void stop(ComponentContext context) {
        TransactionHelper.runInTransaction(this::shutdown);
        this.shutdownPool();
    }

    protected void initPoolConfig() {
        Repository repo;
        PoolConfiguration poolConfig = null;
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (repositoryManager != null && (repo = repositoryManager.getDefaultRepository()) != null) {
            poolConfig = repo.getPoolConfig();
        }
        if (poolConfig == null) {
            poolConfig = new PoolConfiguration();
        }
        this.poolConfig = poolConfig;
    }

    protected void initPool() {
        this.initPoolConfig();
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotal(this.poolConfig.getMaxPoolSize());
        config.setMaxTotalPerKey(this.poolConfig.getMaxPoolSize());
        config.setMaxIdlePerKey(this.poolConfig.getMaxPoolSize());
        config.setMinIdlePerKey(this.poolConfig.getMinPoolSize());
        config.setMaxWaitMillis((long)this.poolConfig.getBlockingTimeoutMillis());
        this.basePool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SessionFactory(), config);
        this.pool = PoolUtils.erodingPool(this.basePool);
    }

    protected void shutdownPool() {
        this.pool.close();
    }

    public void resetPool() {
        this.basePool.clear();
    }

    public GenericKeyedObjectPool<String, ?> getPool() {
        return this.basePool;
    }

    public void initRepositories() {
        TransactionHelper.runInTransaction(this::doInitRepositories);
    }

    protected void doCreateRepositories() {
        this.repositories.clear();
        for (String repositoryName : this.getRepositoryNames()) {
            RepositoryFactory factory = this.getFactory(repositoryName);
            if (factory == null) continue;
            this.createRepository(repositoryName, factory);
        }
    }

    protected void createRepository(String repositoryName, RepositoryFactory factory) {
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        String prop = Framework.getProperty((String)CLUSTER_START_DURATION_PROP);
        Duration duration = DurationUtils.parsePositive((String)prop, (Duration)CLUSTER_START_DURATION_DEFAULT);
        Duration pollDelay = Duration.ofSeconds(1L);
        clusterService.runAtomically("start-repository-" + repositoryName, duration, pollDelay, () -> {
            org.nuxeo.ecm.core.model.Repository repository = (org.nuxeo.ecm.core.model.Repository)factory.call();
            this.repositories.put(repositoryName, repository);
        });
    }

    protected void doInitRepositories() {
        RepositoryInitializationHandler handler = RepositoryInitializationHandler.getInstance();
        if (handler == null) {
            return;
        }
        for (String name : this.getRepositoryNames()) {
            this.initializeRepository(handler, name);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    protected void initializeRepository(final RepositoryInitializationHandler handler, String name) {
        new UnrestrictedSessionRunner(name){

            public void run() {
                handler.initializeRepository(this.session);
            }
        }.runUnrestricted();
    }

    public org.nuxeo.ecm.core.model.Repository getRepository(String repositoryName) {
        return this.repositories.get(repositoryName);
    }

    protected RepositoryFactory getFactory(String repositoryName) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (repositoryManager == null) {
            return null;
        }
        Repository repo = repositoryManager.getRepository(repositoryName);
        if (repo == null) {
            return null;
        }
        RepositoryFactory repositoryFactory = (RepositoryFactory)repo.getRepositoryFactory();
        if (repositoryFactory == null) {
            throw new NullPointerException("Missing repositoryFactory for repository: " + repositoryName);
        }
        return repositoryFactory;
    }

    public List<String> getRepositoryNames() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        return repositoryManager.getRepositoryNames();
    }

    public int getActiveSessionsCount() {
        return this.pool.getNumActive();
    }

    public int getActiveSessionsCount(String repositoryName) {
        return this.pool.getNumActive((Object)repositoryName);
    }

    public Session getSession(String repositoryName) {
        if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            throw new NuxeoException("Cannot use a session outside a transaction");
        }
        TransactionHelper.checkTransactionTimeout();
        ThreadLocal threadSessions = SESSIONS.computeIfAbsent(repositoryName, r -> new ThreadLocal());
        Session session = (Session)threadSessions.get();
        if (session == null) {
            if (!TransactionHelper.isTransactionActive()) {
                throw new NuxeoException("Cannot use a session when transaction is marked rollback-only");
            }
            session = this.getSessionFromPool(repositoryName, threadSessions::remove);
            threadSessions.set(session);
        }
        return session;
    }

    protected Session getSessionFromPool(String repositoryName, Runnable cleanup) {
        Session session;
        try {
            session = (Session)this.pool.borrowObject((Object)repositoryName);
        }
        catch (NoSuchElementException e) {
            String err = String.format("Connection pool is fully used, consider increasing nuxeo.vcs.blocking-timeout-millis (currently %s) or nuxeo.vcs.max-pool-size (currently %s)", this.poolConfig.getBlockingTimeoutMillis(), this.poolConfig.getMaxPoolSize());
            throw new NuxeoException(err, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new NuxeoException((Throwable)e);
        }
        TransactionHelper.registerSynchronization((Synchronization)new SessionSynchronization(session, cleanup));
        session.start();
        return session;
    }

    protected class SessionFactory
    extends BaseKeyedPooledObjectFactory<String, Session> {
        protected SessionFactory() {
        }

        public Session create(String repositoryName) throws Exception {
            org.nuxeo.ecm.core.model.Repository repository = RepositoryService.this.getRepository(repositoryName);
            if (repository == null) {
                throw new DocumentNotFoundException("No such repository: " + repositoryName);
            }
            return repository.getSession();
        }

        public PooledObject<Session> wrap(Session session) {
            return new DefaultPooledObject((Object)session);
        }

        public void destroyObject(String repositoryName, PooledObject<Session> p) throws Exception {
            ((Session)p.getObject()).destroy();
        }
    }

    protected class SessionSynchronization
    implements Synchronization {
        protected final Session session;
        protected final Runnable cleanup;

        protected SessionSynchronization(Session session, Runnable cleanup) {
            this.session = session;
            this.cleanup = cleanup;
        }

        public void beforeCompletion() {
            this.session.end();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            boolean completedAbruptly = true;
            try {
                if (status == 3) {
                    this.session.commit();
                } else if (status == 4) {
                    this.session.rollback();
                } else {
                    log.error((Object)("Unexpected afterCompletion status: " + status));
                }
                completedAbruptly = false;
            }
            finally {
                try {
                    String repositoryName = this.session.getRepositoryName();
                    if (status == 3 && !completedAbruptly) {
                        RepositoryService.this.pool.returnObject((Object)repositoryName, (Object)this.session);
                    } else {
                        RepositoryService.this.pool.invalidateObject((Object)repositoryName, (Object)this.session);
                    }
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.error((Object)e, (Throwable)e);
                }
                finally {
                    this.cleanup.run();
                }
            }
        }
    }
}

