/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;

@XObject(value="item")
public class PermissionUIItemDescriptor {
    @XNode(value="@show")
    private Boolean show;
    @XNode(value="@order")
    private Integer order;
    @XNode(value="@denyPermission")
    private String denyPermission;
    @XNode(value="@id")
    private String id;
    private String permission = "";

    @XContent
    protected void setPermission(String permission) {
        this.permission = permission.trim();
    }

    public PermissionUIItemDescriptor() {
    }

    public PermissionUIItemDescriptor(PermissionUIItemDescriptor referenceDescriptor) {
        this.show = referenceDescriptor.show;
        this.order = referenceDescriptor.order;
        this.permission = referenceDescriptor.permission;
        this.denyPermission = referenceDescriptor.denyPermission;
        this.id = referenceDescriptor.id;
    }

    public int getOrder() {
        if (this.order == null) {
            return 0;
        }
        return this.order;
    }

    public boolean isShown() {
        if (this.show == null) {
            return true;
        }
        return this.show;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getDenyPermission() {
        if (this.denyPermission != null) {
            return this.denyPermission;
        }
        return this.permission;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        return this.permission;
    }

    public boolean equals(Object other) {
        if (other instanceof PermissionUIItemDescriptor) {
            PermissionUIItemDescriptor otherPid = (PermissionUIItemDescriptor)other;
            if (!this.permission.equals(otherPid.permission)) {
                return false;
            }
            if (this.show != null ? !this.show.equals(otherPid.show) : otherPid.show != null) {
                return false;
            }
            if (this.order != null ? !this.order.equals(otherPid.order) : otherPid.order != null) {
                return false;
            }
            if (this.getId() != null ? !this.getId().equals(otherPid.getId()) : otherPid.getId() != null) {
                return false;
            }
            return !(this.getDenyPermission() != null ? !this.getDenyPermission().equals(otherPid.getDenyPermission()) : otherPid.getDenyPermission() != null);
        }
        return false;
    }

    public void merge(PermissionUIItemDescriptor pid) {
        if (!this.permission.equals(pid.permission)) {
            throw new NuxeoException(String.format("cannot merge permission item '%s' with '%s'", this.permission, pid.permission));
        }
        this.show = pid.show != null ? pid.show : this.show;
        this.order = pid.order != null ? pid.order : this.order;
        this.id = pid.id != null ? pid.id : this.id;
        this.denyPermission = pid.denyPermission != null ? pid.denyPermission : this.denyPermission;
    }

    public String toString() {
        if (this.denyPermission != null) {
            return String.format("PermissionUIItemDescriptor[%s (deny %s)]", this.permission, this.denyPermission);
        }
        return String.format("PermissionUIItemDescriptor[%s]", this.permission);
    }
}

