/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.stream.StreamMetricsComputation;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class StreamMetricsProcessor
implements StreamProcessorTopology {
    protected static final Duration DEFAULT_INTERVAL = Duration.ofMinutes(1L);
    protected static final String STREAM_METRICS_FETCH_INTERVAL = "metrics.streams.interval";
    protected static final String STREAM_METRICS_LIST = "metrics.streams.list";

    @Override
    public Topology getTopology(Map<String, String> options) {
        ConfigurationService confService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        Duration interval = confService.getDuration(STREAM_METRICS_FETCH_INTERVAL, DEFAULT_INTERVAL);
        String streams = confService.getString(STREAM_METRICS_LIST, null);
        List<String> inputStreams = this.parseInputStreams(streams);
        return Topology.builder().addComputation(() -> new StreamMetricsComputation(interval, inputStreams), Collections.singletonList("i1:input/null")).build();
    }

    protected List<String> parseInputStreams(String streams) {
        if (streams == null || streams.isBlank()) {
            return null;
        }
        return Arrays.stream(streams.split(",")).map(String::trim).collect(Collectors.toList());
    }
}

