/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.security.ChangePasswordRequest;
import org.elasticsearch.client.security.ClearPrivilegesCacheRequest;
import org.elasticsearch.client.security.ClearRealmCacheRequest;
import org.elasticsearch.client.security.ClearRolesCacheRequest;
import org.elasticsearch.client.security.CreateApiKeyRequest;
import org.elasticsearch.client.security.CreateTokenRequest;
import org.elasticsearch.client.security.DelegatePkiAuthenticationRequest;
import org.elasticsearch.client.security.DeletePrivilegesRequest;
import org.elasticsearch.client.security.DeleteRoleMappingRequest;
import org.elasticsearch.client.security.DeleteRoleRequest;
import org.elasticsearch.client.security.DeleteUserRequest;
import org.elasticsearch.client.security.DisableUserRequest;
import org.elasticsearch.client.security.EnableUserRequest;
import org.elasticsearch.client.security.GetApiKeyRequest;
import org.elasticsearch.client.security.GetPrivilegesRequest;
import org.elasticsearch.client.security.GetRoleMappingsRequest;
import org.elasticsearch.client.security.GetRolesRequest;
import org.elasticsearch.client.security.GetUsersRequest;
import org.elasticsearch.client.security.HasPrivilegesRequest;
import org.elasticsearch.client.security.InvalidateApiKeyRequest;
import org.elasticsearch.client.security.InvalidateTokenRequest;
import org.elasticsearch.client.security.PutPrivilegesRequest;
import org.elasticsearch.client.security.PutRoleMappingRequest;
import org.elasticsearch.client.security.PutRoleRequest;
import org.elasticsearch.client.security.PutUserRequest;
import org.elasticsearch.client.security.SetUserEnabledRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;

final class SecurityRequestConverters {
    private SecurityRequestConverters() {
    }

    static Request changePassword(ChangePasswordRequest changePasswordRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/user").addPathPart(changePasswordRequest.getUsername()).addPathPartAsIs("_password").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)changePasswordRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(changePasswordRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request getUsers(GetUsersRequest getUsersRequest) {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/user");
        if (getUsersRequest.getUsernames().size() > 0) {
            builder.addPathPart(Strings.collectionToCommaDelimitedString(getUsersRequest.getUsernames()));
        }
        return new Request("GET", builder.build());
    }

    static Request putUser(PutUserRequest putUserRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/user").addPathPart(putUserRequest.getUser().getUsername()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)putUserRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(putUserRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request deleteUser(DeleteUserRequest deleteUserRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security", "user").addPathPart(deleteUserRequest.getName()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(deleteUserRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request putRoleMapping(PutRoleMappingRequest putRoleMappingRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role_mapping").addPathPart(putRoleMappingRequest.getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)putRoleMappingRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(putRoleMappingRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request getRoleMappings(GetRoleMappingsRequest getRoleMappingRequest) throws IOException {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder();
        builder.addPathPartAsIs("_security/role_mapping");
        if (getRoleMappingRequest.getRoleMappingNames().size() > 0) {
            builder.addPathPart(Strings.collectionToCommaDelimitedString(getRoleMappingRequest.getRoleMappingNames()));
        }
        return new Request("GET", builder.build());
    }

    static Request enableUser(EnableUserRequest enableUserRequest) {
        return SecurityRequestConverters.setUserEnabled(enableUserRequest);
    }

    static Request disableUser(DisableUserRequest disableUserRequest) {
        return SecurityRequestConverters.setUserEnabled(disableUserRequest);
    }

    private static Request setUserEnabled(SetUserEnabledRequest setUserEnabledRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/user").addPathPart(setUserEnabledRequest.getUsername()).addPathPart(setUserEnabledRequest.isEnabled() ? "_enable" : "_disable").build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(setUserEnabledRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request hasPrivileges(HasPrivilegesRequest hasPrivilegesRequest) throws IOException {
        Request request = new Request("GET", "/_security/user/_has_privileges");
        request.setEntity(RequestConverters.createEntity((ToXContent)hasPrivilegesRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request clearRealmCache(ClearRealmCacheRequest clearRealmCacheRequest) {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/realm");
        if (!clearRealmCacheRequest.getRealms().isEmpty()) {
            builder.addCommaSeparatedPathParts(clearRealmCacheRequest.getRealms().toArray(Strings.EMPTY_ARRAY));
        } else {
            builder.addPathPart("_all");
        }
        String endpoint = builder.addPathPartAsIs("_clear_cache").build();
        Request request = new Request("POST", endpoint);
        if (!clearRealmCacheRequest.getUsernames().isEmpty()) {
            RequestConverters.Params params = new RequestConverters.Params();
            params.putParam("usernames", Strings.collectionToCommaDelimitedString(clearRealmCacheRequest.getUsernames()));
            request.addParameters(params.asMap());
        }
        return request;
    }

    static Request clearRolesCache(ClearRolesCacheRequest disableCacheRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role").addCommaSeparatedPathParts(disableCacheRequest.names()).addPathPart("_clear_cache").build();
        return new Request("POST", endpoint);
    }

    static Request clearPrivilegesCache(ClearPrivilegesCacheRequest disableCacheRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/privilege").addCommaSeparatedPathParts(disableCacheRequest.applications()).addPathPart("_clear_cache").build();
        return new Request("POST", endpoint);
    }

    static Request deleteRoleMapping(DeleteRoleMappingRequest deleteRoleMappingRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role_mapping").addPathPart(deleteRoleMappingRequest.getName()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(deleteRoleMappingRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request deleteRole(DeleteRoleRequest deleteRoleRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role").addPathPart(deleteRoleRequest.getName()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(deleteRoleRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request getRoles(GetRolesRequest getRolesRequest) {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder();
        builder.addPathPartAsIs("_security/role");
        if (getRolesRequest.getRoleNames().size() > 0) {
            builder.addPathPart(Strings.collectionToCommaDelimitedString(getRolesRequest.getRoleNames()));
        }
        return new Request("GET", builder.build());
    }

    static Request createToken(CreateTokenRequest createTokenRequest) throws IOException {
        Request request = new Request("POST", "/_security/oauth2/token");
        request.setEntity(RequestConverters.createEntity((ToXContent)createTokenRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request delegatePkiAuthentication(DelegatePkiAuthenticationRequest delegatePkiAuthenticationRequest) throws IOException {
        Request request = new Request("POST", "/_security/delegate_pki");
        request.setEntity(RequestConverters.createEntity((ToXContent)delegatePkiAuthenticationRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request invalidateToken(InvalidateTokenRequest invalidateTokenRequest) throws IOException {
        Request request = new Request("DELETE", "/_security/oauth2/token");
        request.setEntity(RequestConverters.createEntity((ToXContent)invalidateTokenRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getPrivileges(GetPrivilegesRequest getPrivilegesRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/privilege").addPathPart(getPrivilegesRequest.getApplicationName()).addCommaSeparatedPathParts(getPrivilegesRequest.getPrivilegeNames()).build();
        return new Request("GET", endpoint);
    }

    static Request putPrivileges(PutPrivilegesRequest putPrivilegesRequest) throws IOException {
        Request request = new Request("PUT", "/_security/privilege");
        request.setEntity(RequestConverters.createEntity((ToXContent)putPrivilegesRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(putPrivilegesRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request deletePrivileges(DeletePrivilegesRequest deletePrivilegeRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/privilege").addPathPart(deletePrivilegeRequest.getApplication()).addCommaSeparatedPathParts(deletePrivilegeRequest.getPrivileges()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(deletePrivilegeRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request putRole(PutRoleRequest putRoleRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role").addPathPart(putRoleRequest.getRole().getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)putRoleRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(putRoleRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request createApiKey(CreateApiKeyRequest createApiKeyRequest) throws IOException {
        Request request = new Request("POST", "/_security/api_key");
        request.setEntity(RequestConverters.createEntity((ToXContent)createApiKeyRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        params.withRefreshPolicy(createApiKeyRequest.getRefreshPolicy());
        request.addParameters(params.asMap());
        return request;
    }

    static Request getApiKey(GetApiKeyRequest getApiKeyRequest) throws IOException {
        Request request = new Request("GET", "/_security/api_key");
        if (Strings.hasText((String)getApiKeyRequest.getId())) {
            request.addParameter("id", getApiKeyRequest.getId());
        }
        if (Strings.hasText((String)getApiKeyRequest.getName())) {
            request.addParameter("name", getApiKeyRequest.getName());
        }
        if (Strings.hasText((String)getApiKeyRequest.getUserName())) {
            request.addParameter("username", getApiKeyRequest.getUserName());
        }
        if (Strings.hasText((String)getApiKeyRequest.getRealmName())) {
            request.addParameter("realm_name", getApiKeyRequest.getRealmName());
        }
        request.addParameter("owner", Boolean.toString(getApiKeyRequest.ownedByAuthenticatedUser()));
        return request;
    }

    static Request invalidateApiKey(InvalidateApiKeyRequest invalidateApiKeyRequest) throws IOException {
        Request request = new Request("DELETE", "/_security/api_key");
        request.setEntity(RequestConverters.createEntity((ToXContent)invalidateApiKeyRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }
}

