/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.preprocessing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class OneHotEncoding
implements PreProcessor {
    public static final String NAME = "one_hot_encoding";
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField HOT_MAP = new ParseField("hot_map", new String[0]);
    public static final ConstructingObjectParser<OneHotEncoding, Void> PARSER = new ConstructingObjectParser("one_hot_encoding", true, a -> new OneHotEncoding((String)a[0], (Map)a[1]));
    private final String field;
    private final Map<String, String> hotMap;

    public static OneHotEncoding fromXContent(XContentParser parser) {
        return (OneHotEncoding)PARSER.apply(parser, null);
    }

    public OneHotEncoding(String field, Map<String, String> hotMap) {
        this.field = Objects.requireNonNull(field);
        this.hotMap = Collections.unmodifiableMap(Objects.requireNonNull(hotMap));
    }

    public String getField() {
        return this.field;
    }

    public Map<String, String> getHotMap() {
        return this.hotMap;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(HOT_MAP.getPreferredName(), this.hotMap);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneHotEncoding that = (OneHotEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.hotMap, that.hotMap);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.hotMap);
    }

    public Builder builder(String field) {
        return new Builder(field);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), HOT_MAP);
    }

    public static class Builder {
        private String field;
        private Map<String, String> hotMap = new HashMap<String, String>();

        public Builder(String field) {
            this.field = field;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setHotMap(Map<String, String> hotMap) {
            this.hotMap = new HashMap<String, String>(hotMap);
            return this;
        }

        public Builder addOneHot(String valueName, String oneHotFeatureName) {
            this.hotMap.put(valueName, oneHotFeatureName);
            return this;
        }

        public OneHotEncoding build() {
            return new OneHotEncoding(this.field, this.hotMap);
        }
    }
}

