/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services.codec;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.nuxeo.ecm.core.api.CoreSession;

public abstract class ObjectCodec<T> {
    protected Class<T> type;

    public static Class<?> findParametrizedType(Class<?> clazz) {
        Type superclass = clazz.getGenericSuperclass();
        while (superclass instanceof Class) {
            superclass = ((Class)superclass).getGenericSuperclass();
        }
        if (superclass == null) {
            throw new RuntimeException("Missing type parameter.");
        }
        Type type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        if (!(type instanceof Class)) {
            throw new RuntimeException("Invalid class parameter type. " + type);
        }
        return (Class)type;
    }

    public ObjectCodec() {
        this.type = ObjectCodec.findParametrizedType(this.getClass());
    }

    public ObjectCodec(Class<T> type) {
        this.type = type;
    }

    public String getType() {
        return this.type.getName();
    }

    public boolean isBuiltin() {
        return false;
    }

    public Class<T> getJavaType() {
        return this.type;
    }

    public void write(JsonGenerator jg, T value) throws IOException {
        if (jg.getCodec() == null) {
            jg.setCodec((com.fasterxml.jackson.core.ObjectCodec)new ObjectMapper());
        }
        jg.writeObject(value);
    }

    public T read(JsonParser jp, CoreSession session) throws IOException {
        if (jp.getCodec() == null) {
            jp.setCodec((com.fasterxml.jackson.core.ObjectCodec)new ObjectMapper());
        }
        return (T)jp.readValueAs(this.type);
    }
}

